/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.OverrideTaskStepProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="TaskRunRequest")
public final class TaskRunRequest
extends RunRequest {
    @JsonProperty(value="taskId", required=true)
    private String taskId;
    @JsonProperty(value="overrideTaskStepProperties")
    private OverrideTaskStepProperties overrideTaskStepProperties;
    private static final ClientLogger LOGGER = new ClientLogger(TaskRunRequest.class);

    public String taskId() {
        return this.taskId;
    }

    public TaskRunRequest withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public OverrideTaskStepProperties overrideTaskStepProperties() {
        return this.overrideTaskStepProperties;
    }

    public TaskRunRequest withOverrideTaskStepProperties(OverrideTaskStepProperties overrideTaskStepProperties) {
        this.overrideTaskStepProperties = overrideTaskStepProperties;
        return this;
    }

    @Override
    public TaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public TaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public TaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.taskId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property taskId in model TaskRunRequest"));
        }
        if (this.overrideTaskStepProperties() != null) {
            this.overrideTaskStepProperties().validate();
        }
    }
}

