// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.fluent.models.CacheRuleInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The result of a request to list cache rules for a container registry.
 */
@Fluent
public final class CacheRulesListResult {
    /*
     * The list of cache rules.
     */
    @JsonProperty(value = "value")
    private List<CacheRuleInner> value;

    /*
     * If provided, client must use NextLink URI to request next list of cache rules.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Creates an instance of CacheRulesListResult class.
     */
    public CacheRulesListResult() {
    }

    /**
     * Get the value property: The list of cache rules.
     * 
     * @return the value value.
     */
    public List<CacheRuleInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of cache rules.
     * 
     * @param value the value value to set.
     * @return the CacheRulesListResult object itself.
     */
    public CacheRulesListResult withValue(List<CacheRuleInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: If provided, client must use NextLink URI to request next list of cache rules.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: If provided, client must use NextLink URI to request next list of cache rules.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CacheRulesListResult object itself.
     */
    public CacheRulesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
