// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerregistry.models.AuthCredential;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The parameters for updating credential set properties.
 */
@Fluent
public final class CredentialSetUpdateProperties {
    /*
     * List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     */
    @JsonProperty(value = "authCredentials")
    private List<AuthCredential> authCredentials;

    /**
     * Creates an instance of CredentialSetUpdateProperties class.
     */
    public CredentialSetUpdateProperties() {
    }

    /**
     * Get the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @return the authCredentials value.
     */
    public List<AuthCredential> authCredentials() {
        return this.authCredentials;
    }

    /**
     * Set the authCredentials property: List of authentication credentials stored for an upstream.
     * Usually consists of a primary and an optional secondary credential.
     * 
     * @param authCredentials the authCredentials value to set.
     * @return the CredentialSetUpdateProperties object itself.
     */
    public CredentialSetUpdateProperties withAuthCredentials(List<AuthCredential> authCredentials) {
        this.authCredentials = authCredentials;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (authCredentials() != null) {
            authCredentials().forEach(e -> e.validate());
        }
    }
}
