/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AuthInfo;
import com.azure.resourcemanager.containerregistry.models.SourceControlType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SourceProperties {
    @JsonProperty(value="sourceControlType", required=true)
    private SourceControlType sourceControlType;
    @JsonProperty(value="repositoryUrl", required=true)
    private String repositoryUrl;
    @JsonProperty(value="branch")
    private String branch;
    @JsonProperty(value="sourceControlAuthProperties")
    private AuthInfo sourceControlAuthProperties;
    private static final ClientLogger LOGGER = new ClientLogger(SourceProperties.class);

    public SourceControlType sourceControlType() {
        return this.sourceControlType;
    }

    public SourceProperties withSourceControlType(SourceControlType sourceControlType) {
        this.sourceControlType = sourceControlType;
        return this;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public SourceProperties withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public SourceProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public AuthInfo sourceControlAuthProperties() {
        return this.sourceControlAuthProperties;
    }

    public SourceProperties withSourceControlAuthProperties(AuthInfo sourceControlAuthProperties) {
        this.sourceControlAuthProperties = sourceControlAuthProperties;
        return this;
    }

    public void validate() {
        if (this.sourceControlType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceControlType in model SourceProperties"));
        }
        if (this.repositoryUrl() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property repositoryUrl in model SourceProperties"));
        }
        if (this.sourceControlAuthProperties() != null) {
            this.sourceControlAuthProperties().validate();
        }
    }
}

