// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The update parameters for scope map properties.
 */
@Fluent
public final class ScopeMapPropertiesUpdateParameters {
    /*
     * The user friendly description of the scope map.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete
     */
    @JsonProperty(value = "actions")
    private List<String> actions;

    /**
     * Creates an instance of ScopeMapPropertiesUpdateParameters class.
     */
    public ScopeMapPropertiesUpdateParameters() {
    }

    /**
     * Get the description property: The user friendly description of the scope map.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The user friendly description of the scope map.
     * 
     * @param description the description value to set.
     * @return the ScopeMapPropertiesUpdateParameters object itself.
     */
    public ScopeMapPropertiesUpdateParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actions property: The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: The list of scope permissions for registry artifacts.
     * E.g. repositories/repository-name/pull,
     * repositories/repository-name/delete.
     * 
     * @param actions the actions value to set.
     * @return the ScopeMapPropertiesUpdateParameters object itself.
     */
    public ScopeMapPropertiesUpdateParameters withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
