/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.DefaultAction;
import com.azure.resourcemanager.containerregistry.models.IpRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class NetworkRuleSet {
    @JsonProperty(value="defaultAction", required=true)
    private DefaultAction defaultAction;
    @JsonProperty(value="ipRules")
    private List<IpRule> ipRules;
    private static final ClientLogger LOGGER = new ClientLogger(NetworkRuleSet.class);

    public DefaultAction defaultAction() {
        return this.defaultAction;
    }

    public NetworkRuleSet withDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
        return this;
    }

    public List<IpRule> ipRules() {
        return this.ipRules;
    }

    public NetworkRuleSet withIpRules(List<IpRule> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public void validate() {
        if (this.defaultAction() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property defaultAction in model NetworkRuleSet"));
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
    }
}

