/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.resourcemanager.containerregistry.fluent.models.RunInner;
import com.azure.resourcemanager.containerregistry.models.Architecture;
import com.azure.resourcemanager.containerregistry.models.OverridingValue;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RegistryDockerTaskRunRequest;
import com.azure.resourcemanager.containerregistry.models.RegistryEncodedTaskRunRequest;
import com.azure.resourcemanager.containerregistry.models.RegistryFileTaskRunRequest;
import com.azure.resourcemanager.containerregistry.models.RunStatus;
import com.azure.resourcemanager.containerregistry.models.RunType;
import com.azure.resourcemanager.containerregistry.models.Variant;
import com.azure.resourcemanager.resources.fluentcore.model.Executable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import java.time.OffsetDateTime;
import java.util.Map;

public interface RegistryTaskRun
extends HasInnerModel<RunInner>,
Refreshable<RegistryTaskRun> {
    public String resourceGroupName();

    public String registryName();

    public String taskName();

    public RunStatus status();

    public RunType runType();

    public OffsetDateTime lastUpdatedTime();

    public OffsetDateTime createTime();

    public boolean isArchiveEnabled();

    public PlatformProperties platform();

    public int cpu();

    public ProvisioningState provisioningState();

    public String runId();

    public static interface DefinitionStages {

        public static interface RunRequestExecutable
        extends Archive,
        Executable<RegistryTaskRun> {
        }

        public static interface RunRequestExecutableWithSourceLocation
        extends AgentConfiguration,
        RunRequestExecutable {
            public RunRequestExecutableWithSourceLocation withSourceLocation(String var1);

            public RunRequestExecutableWithSourceLocation withTimeout(int var1);
        }

        public static interface Archive {
            public RunRequestExecutable withArchiveEnabled(boolean var1);
        }

        public static interface AgentConfiguration {
            public RunRequestExecutable withCpuCount(int var1);
        }

        public static interface RunRequestType {
            public RegistryFileTaskRunRequest.DefinitionStages.Blank withFileTaskRunRequest();

            public RegistryEncodedTaskRunRequest.DefinitionStages.Blank withEncodedTaskRunRequest();

            public RegistryDockerTaskRunRequest.DefinitionStages.Blank withDockerTaskRunRequest();
        }

        public static interface Platform {
            public RunRequestType withLinux();

            public RunRequestType withWindows();

            public RunRequestType withLinux(Architecture var1);

            public RunRequestType withWindows(Architecture var1);

            public RunRequestType withLinux(Architecture var1, Variant var2);

            public RunRequestType withWindows(Architecture var1, Variant var2);

            public RunRequestType withPlatform(PlatformProperties var1);
        }

        public static interface RegistryTaskRunRequest
        extends RunRequestExecutable {
            public RegistryTaskRunRequest withOverridingValues(Map<String, OverridingValue> var1);

            public RegistryTaskRunRequest withOverridingValue(String var1, OverridingValue var2);

            @Override
            public RegistryTaskRunRequest withArchiveEnabled(boolean var1);
        }

        public static interface PlatformAltTaskRunRequest
        extends Platform {
            public RegistryTaskRunRequest withTaskRunRequest(String var1);
        }

        public static interface BlankFromRuns {
            public PlatformAltTaskRunRequest withExistingRegistry(String var1, String var2);
        }

        public static interface BlankFromRegistry
        extends PlatformAltTaskRunRequest {
        }
    }

    public static interface Definition
    extends DefinitionStages.BlankFromRegistry,
    DefinitionStages.BlankFromRuns,
    DefinitionStages.Platform,
    DefinitionStages.PlatformAltTaskRunRequest,
    DefinitionStages.RegistryTaskRunRequest,
    DefinitionStages.RunRequestType,
    DefinitionStages.RunRequestExecutableWithSourceLocation,
    DefinitionStages.RunRequestExecutable {
    }
}

