/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="EncodedTask")
public final class EncodedTaskStep
extends TaskStepProperties {
    @JsonProperty(value="encodedTaskContent", required=true)
    private String encodedTaskContent;
    @JsonProperty(value="encodedValuesContent")
    private String encodedValuesContent;
    @JsonProperty(value="values")
    private List<SetValue> values;
    private static final ClientLogger LOGGER = new ClientLogger(EncodedTaskStep.class);

    public String encodedTaskContent() {
        return this.encodedTaskContent;
    }

    public EncodedTaskStep withEncodedTaskContent(String encodedTaskContent) {
        this.encodedTaskContent = encodedTaskContent;
        return this;
    }

    public String encodedValuesContent() {
        return this.encodedValuesContent;
    }

    public EncodedTaskStep withEncodedValuesContent(String encodedValuesContent) {
        this.encodedValuesContent = encodedValuesContent;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public EncodedTaskStep withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    @Override
    public EncodedTaskStep withContextPath(String contextPath) {
        super.withContextPath(contextPath);
        return this;
    }

    @Override
    public EncodedTaskStep withContextAccessToken(String contextAccessToken) {
        super.withContextAccessToken(contextAccessToken);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.encodedTaskContent() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property encodedTaskContent in model EncodedTaskStep"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
    }
}

