/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskProperties;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.IdentityProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.azure.resourcemanager.containerregistry.models.TriggerProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class TaskInner
extends Resource {
    @JsonProperty(value="identity")
    private IdentityProperties identity;
    @JsonProperty(value="properties")
    private TaskProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    public IdentityProperties identity() {
        return this.identity;
    }

    public TaskInner withIdentity(IdentityProperties identity) {
        this.identity = identity;
        return this;
    }

    private TaskProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public TaskInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public TaskInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime creationDate() {
        return this.innerProperties() == null ? null : this.innerProperties().creationDate();
    }

    public TaskStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public TaskInner withStatus(TaskStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    public PlatformProperties platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    public TaskInner withPlatform(PlatformProperties platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    public TaskInner withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    public TaskInner withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    public Integer timeout() {
        return this.innerProperties() == null ? null : this.innerProperties().timeout();
    }

    public TaskInner withTimeout(Integer timeout) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withTimeout(timeout);
        return this;
    }

    public TaskStepProperties step() {
        return this.innerProperties() == null ? null : this.innerProperties().step();
    }

    public TaskInner withStep(TaskStepProperties step) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withStep(step);
        return this;
    }

    public TriggerProperties trigger() {
        return this.innerProperties() == null ? null : this.innerProperties().trigger();
    }

    public TaskInner withTrigger(TriggerProperties trigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withTrigger(trigger);
        return this;
    }

    public Credentials credentials() {
        return this.innerProperties() == null ? null : this.innerProperties().credentials();
    }

    public TaskInner withCredentials(Credentials credentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withCredentials(credentials);
        return this;
    }

    public String logTemplate() {
        return this.innerProperties() == null ? null : this.innerProperties().logTemplate();
    }

    public TaskInner withLogTemplate(String logTemplate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withLogTemplate(logTemplate);
        return this;
    }

    public Boolean isSystemTask() {
        return this.innerProperties() == null ? null : this.innerProperties().isSystemTask();
    }

    public TaskInner withIsSystemTask(Boolean isSystemTask) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TaskProperties();
        }
        this.innerProperties().withIsSystemTask(isSystemTask);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

