// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The parameters for a task run request. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("TaskRunRequest")
@Fluent
public final class TaskRunRequest extends RunRequest {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TaskRunRequest.class);

    /*
     * The resource ID of task against which run has to be queued.
     */
    @JsonProperty(value = "taskId", required = true)
    private String taskId;

    /*
     * Set of overridable parameters that can be passed when running a Task.
     */
    @JsonProperty(value = "overrideTaskStepProperties")
    private OverrideTaskStepProperties overrideTaskStepProperties;

    /**
     * Get the taskId property: The resource ID of task against which run has to be queued.
     *
     * @return the taskId value.
     */
    public String taskId() {
        return this.taskId;
    }

    /**
     * Set the taskId property: The resource ID of task against which run has to be queued.
     *
     * @param taskId the taskId value to set.
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    /**
     * Get the overrideTaskStepProperties property: Set of overridable parameters that can be passed when running a
     * Task.
     *
     * @return the overrideTaskStepProperties value.
     */
    public OverrideTaskStepProperties overrideTaskStepProperties() {
        return this.overrideTaskStepProperties;
    }

    /**
     * Set the overrideTaskStepProperties property: Set of overridable parameters that can be passed when running a
     * Task.
     *
     * @param overrideTaskStepProperties the overrideTaskStepProperties value to set.
     * @return the TaskRunRequest object itself.
     */
    public TaskRunRequest withOverrideTaskStepProperties(OverrideTaskStepProperties overrideTaskStepProperties) {
        this.overrideTaskStepProperties = overrideTaskStepProperties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (taskId() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property taskId in model TaskRunRequest"));
        }
        if (overrideTaskStepProperties() != null) {
            overrideTaskStepProperties().validate();
        }
    }
}
