// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for EncryptionStatus. */
public final class EncryptionStatus extends ExpandableStringEnum<EncryptionStatus> {
    /** Static value enabled for EncryptionStatus. */
    public static final EncryptionStatus ENABLED = fromString("enabled");

    /** Static value disabled for EncryptionStatus. */
    public static final EncryptionStatus DISABLED = fromString("disabled");

    /**
     * Creates or finds a EncryptionStatus from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EncryptionStatus.
     */
    @JsonCreator
    public static EncryptionStatus fromString(String name) {
        return fromString(name, EncryptionStatus.class);
    }

    /** @return known EncryptionStatus values. */
    public static Collection<EncryptionStatus> values() {
        return values(EncryptionStatus.class);
    }
}
