// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.ImageDescriptor;
import com.azure.resourcemanager.containerregistry.models.ImageUpdateTrigger;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunStatus;
import com.azure.resourcemanager.containerregistry.models.RunType;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerDescriptor;
import com.azure.resourcemanager.containerregistry.models.TimerTriggerDescriptor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Run resource properties. */
@Fluent
public final class RunInner extends ProxyResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RunInner.class);

    /*
     * The properties of a run.
     */
    @JsonProperty(value = "properties")
    private RunProperties innerProperties;

    /*
     * Metadata pertaining to creation and last modification of the resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The properties of a run.
     *
     * @return the innerProperties value.
     */
    private RunProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Metadata pertaining to creation and last modification of the resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the runId property: The unique identifier for the run.
     *
     * @return the runId value.
     */
    public String runId() {
        return this.innerProperties() == null ? null : this.innerProperties().runId();
    }

    /**
     * Set the runId property: The unique identifier for the run.
     *
     * @param runId the runId value to set.
     * @return the RunInner object itself.
     */
    public RunInner withRunId(String runId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withRunId(runId);
        return this;
    }

    /**
     * Get the status property: The current status of the run.
     *
     * @return the status value.
     */
    public RunStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: The current status of the run.
     *
     * @param status the status value to set.
     * @return the RunInner object itself.
     */
    public RunInner withStatus(RunStatus status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the lastUpdatedTime property: The last updated time for the run.
     *
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime lastUpdatedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastUpdatedTime();
    }

    /**
     * Set the lastUpdatedTime property: The last updated time for the run.
     *
     * @param lastUpdatedTime the lastUpdatedTime value to set.
     * @return the RunInner object itself.
     */
    public RunInner withLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    /**
     * Get the runType property: The type of run.
     *
     * @return the runType value.
     */
    public RunType runType() {
        return this.innerProperties() == null ? null : this.innerProperties().runType();
    }

    /**
     * Set the runType property: The type of run.
     *
     * @param runType the runType value to set.
     * @return the RunInner object itself.
     */
    public RunInner withRunType(RunType runType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withRunType(runType);
        return this;
    }

    /**
     * Get the agentPoolName property: The dedicated agent pool for the run.
     *
     * @return the agentPoolName value.
     */
    public String agentPoolName() {
        return this.innerProperties() == null ? null : this.innerProperties().agentPoolName();
    }

    /**
     * Set the agentPoolName property: The dedicated agent pool for the run.
     *
     * @param agentPoolName the agentPoolName value to set.
     * @return the RunInner object itself.
     */
    public RunInner withAgentPoolName(String agentPoolName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withAgentPoolName(agentPoolName);
        return this;
    }

    /**
     * Get the createTime property: The time the run was scheduled.
     *
     * @return the createTime value.
     */
    public OffsetDateTime createTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createTime();
    }

    /**
     * Set the createTime property: The time the run was scheduled.
     *
     * @param createTime the createTime value to set.
     * @return the RunInner object itself.
     */
    public RunInner withCreateTime(OffsetDateTime createTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withCreateTime(createTime);
        return this;
    }

    /**
     * Get the startTime property: The time the run started.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: The time the run started.
     *
     * @param startTime the startTime value to set.
     * @return the RunInner object itself.
     */
    public RunInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the finishTime property: The time the run finished.
     *
     * @return the finishTime value.
     */
    public OffsetDateTime finishTime() {
        return this.innerProperties() == null ? null : this.innerProperties().finishTime();
    }

    /**
     * Set the finishTime property: The time the run finished.
     *
     * @param finishTime the finishTime value to set.
     * @return the RunInner object itself.
     */
    public RunInner withFinishTime(OffsetDateTime finishTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withFinishTime(finishTime);
        return this;
    }

    /**
     * Get the outputImages property: The list of all images that were generated from the run. This is applicable if the
     * run generates base image dependencies.
     *
     * @return the outputImages value.
     */
    public List<ImageDescriptor> outputImages() {
        return this.innerProperties() == null ? null : this.innerProperties().outputImages();
    }

    /**
     * Set the outputImages property: The list of all images that were generated from the run. This is applicable if the
     * run generates base image dependencies.
     *
     * @param outputImages the outputImages value to set.
     * @return the RunInner object itself.
     */
    public RunInner withOutputImages(List<ImageDescriptor> outputImages) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withOutputImages(outputImages);
        return this;
    }

    /**
     * Get the task property: The task against which run was scheduled.
     *
     * @return the task value.
     */
    public String task() {
        return this.innerProperties() == null ? null : this.innerProperties().task();
    }

    /**
     * Set the task property: The task against which run was scheduled.
     *
     * @param task the task value to set.
     * @return the RunInner object itself.
     */
    public RunInner withTask(String task) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withTask(task);
        return this;
    }

    /**
     * Get the imageUpdateTrigger property: The image update trigger that caused the run. This is applicable if the task
     * has base image trigger configured.
     *
     * @return the imageUpdateTrigger value.
     */
    public ImageUpdateTrigger imageUpdateTrigger() {
        return this.innerProperties() == null ? null : this.innerProperties().imageUpdateTrigger();
    }

    /**
     * Set the imageUpdateTrigger property: The image update trigger that caused the run. This is applicable if the task
     * has base image trigger configured.
     *
     * @param imageUpdateTrigger the imageUpdateTrigger value to set.
     * @return the RunInner object itself.
     */
    public RunInner withImageUpdateTrigger(ImageUpdateTrigger imageUpdateTrigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withImageUpdateTrigger(imageUpdateTrigger);
        return this;
    }

    /**
     * Get the sourceTrigger property: The source trigger that caused the run.
     *
     * @return the sourceTrigger value.
     */
    public SourceTriggerDescriptor sourceTrigger() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceTrigger();
    }

    /**
     * Set the sourceTrigger property: The source trigger that caused the run.
     *
     * @param sourceTrigger the sourceTrigger value to set.
     * @return the RunInner object itself.
     */
    public RunInner withSourceTrigger(SourceTriggerDescriptor sourceTrigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withSourceTrigger(sourceTrigger);
        return this;
    }

    /**
     * Get the timerTrigger property: The timer trigger that caused the run.
     *
     * @return the timerTrigger value.
     */
    public TimerTriggerDescriptor timerTrigger() {
        return this.innerProperties() == null ? null : this.innerProperties().timerTrigger();
    }

    /**
     * Set the timerTrigger property: The timer trigger that caused the run.
     *
     * @param timerTrigger the timerTrigger value to set.
     * @return the RunInner object itself.
     */
    public RunInner withTimerTrigger(TimerTriggerDescriptor timerTrigger) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withTimerTrigger(timerTrigger);
        return this;
    }

    /**
     * Get the platform property: The platform properties against which the run will happen.
     *
     * @return the platform value.
     */
    public PlatformProperties platform() {
        return this.innerProperties() == null ? null : this.innerProperties().platform();
    }

    /**
     * Set the platform property: The platform properties against which the run will happen.
     *
     * @param platform the platform value to set.
     * @return the RunInner object itself.
     */
    public RunInner withPlatform(PlatformProperties platform) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withPlatform(platform);
        return this;
    }

    /**
     * Get the agentConfiguration property: The machine configuration of the run agent.
     *
     * @return the agentConfiguration value.
     */
    public AgentProperties agentConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().agentConfiguration();
    }

    /**
     * Set the agentConfiguration property: The machine configuration of the run agent.
     *
     * @param agentConfiguration the agentConfiguration value to set.
     * @return the RunInner object itself.
     */
    public RunInner withAgentConfiguration(AgentProperties agentConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withAgentConfiguration(agentConfiguration);
        return this;
    }

    /**
     * Get the sourceRegistryAuth property: The scope of the credentials that were used to login to the source registry
     * during this run.
     *
     * @return the sourceRegistryAuth value.
     */
    public String sourceRegistryAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceRegistryAuth();
    }

    /**
     * Set the sourceRegistryAuth property: The scope of the credentials that were used to login to the source registry
     * during this run.
     *
     * @param sourceRegistryAuth the sourceRegistryAuth value to set.
     * @return the RunInner object itself.
     */
    public RunInner withSourceRegistryAuth(String sourceRegistryAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withSourceRegistryAuth(sourceRegistryAuth);
        return this;
    }

    /**
     * Get the customRegistries property: The list of custom registries that were logged in during this run.
     *
     * @return the customRegistries value.
     */
    public List<String> customRegistries() {
        return this.innerProperties() == null ? null : this.innerProperties().customRegistries();
    }

    /**
     * Set the customRegistries property: The list of custom registries that were logged in during this run.
     *
     * @param customRegistries the customRegistries value to set.
     * @return the RunInner object itself.
     */
    public RunInner withCustomRegistries(List<String> customRegistries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withCustomRegistries(customRegistries);
        return this;
    }

    /**
     * Get the runErrorMessage property: The error message received from backend systems after the run is scheduled.
     *
     * @return the runErrorMessage value.
     */
    public String runErrorMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().runErrorMessage();
    }

    /**
     * Get the updateTriggerToken property: The update trigger token passed for the Run.
     *
     * @return the updateTriggerToken value.
     */
    public String updateTriggerToken() {
        return this.innerProperties() == null ? null : this.innerProperties().updateTriggerToken();
    }

    /**
     * Set the updateTriggerToken property: The update trigger token passed for the Run.
     *
     * @param updateTriggerToken the updateTriggerToken value to set.
     * @return the RunInner object itself.
     */
    public RunInner withUpdateTriggerToken(String updateTriggerToken) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withUpdateTriggerToken(updateTriggerToken);
        return this;
    }

    /**
     * Get the logArtifact property: The image description for the log artifact.
     *
     * @return the logArtifact value.
     */
    public ImageDescriptor logArtifact() {
        return this.innerProperties() == null ? null : this.innerProperties().logArtifact();
    }

    /**
     * Get the provisioningState property: The provisioning state of a run.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: The provisioning state of a run.
     *
     * @param provisioningState the provisioningState value to set.
     * @return the RunInner object itself.
     */
    public RunInner withProvisioningState(ProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Get the isArchiveEnabled property: The value that indicates whether archiving is enabled or not.
     *
     * @return the isArchiveEnabled value.
     */
    public Boolean isArchiveEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isArchiveEnabled();
    }

    /**
     * Set the isArchiveEnabled property: The value that indicates whether archiving is enabled or not.
     *
     * @param isArchiveEnabled the isArchiveEnabled value to set.
     * @return the RunInner object itself.
     */
    public RunInner withIsArchiveEnabled(Boolean isArchiveEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RunProperties();
        }
        this.innerProperties().withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
