// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.Status;
import com.azure.resourcemanager.containerregistry.models.ZoneRedundancy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of a replication. */
@Fluent
public final class ReplicationProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ReplicationProperties.class);

    /*
     * The provisioning state of the replication at the time the operation was
     * called.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * The status of the replication at the time the operation was called.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private Status status;

    /*
     * Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is
     * disabled, however its data will continue to be synced with other
     * replications.
     */
    @JsonProperty(value = "regionEndpointEnabled")
    private Boolean regionEndpointEnabled;

    /*
     * Whether or not zone redundancy is enabled for this container registry
     * replication
     */
    @JsonProperty(value = "zoneRedundancy")
    private ZoneRedundancy zoneRedundancy;

    /**
     * Get the provisioningState property: The provisioning state of the replication at the time the operation was
     * called.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the status property: The status of the replication at the time the operation was called.
     *
     * @return the status value.
     */
    public Status status() {
        return this.status;
    }

    /**
     * Get the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     *
     * @return the regionEndpointEnabled value.
     */
    public Boolean regionEndpointEnabled() {
        return this.regionEndpointEnabled;
    }

    /**
     * Set the regionEndpointEnabled property: Specifies whether the replication's regional endpoint is enabled.
     * Requests will not be routed to a replication whose regional endpoint is disabled, however its data will continue
     * to be synced with other replications.
     *
     * @param regionEndpointEnabled the regionEndpointEnabled value to set.
     * @return the ReplicationProperties object itself.
     */
    public ReplicationProperties withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        this.regionEndpointEnabled = regionEndpointEnabled;
        return this;
    }

    /**
     * Get the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry
     * replication.
     *
     * @return the zoneRedundancy value.
     */
    public ZoneRedundancy zoneRedundancy() {
        return this.zoneRedundancy;
    }

    /**
     * Set the zoneRedundancy property: Whether or not zone redundancy is enabled for this container registry
     * replication.
     *
     * @param zoneRedundancy the zoneRedundancy value to set.
     * @return the ReplicationProperties object itself.
     */
    public ReplicationProperties withZoneRedundancy(ZoneRedundancy zoneRedundancy) {
        this.zoneRedundancy = zoneRedundancy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() != null) {
            status().validate();
        }
    }
}
