/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.RunRequest;
import com.azure.resourcemanager.containerregistry.models.SetValue;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeName(value="FileTaskRunRequest")
public final class FileTaskRunRequest
extends RunRequest {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(FileTaskRunRequest.class);
    @JsonProperty(value="taskFilePath", required=true)
    private String taskFilePath;
    @JsonProperty(value="valuesFilePath")
    private String valuesFilePath;
    @JsonProperty(value="values")
    private List<SetValue> values;
    @JsonProperty(value="timeout")
    private Integer timeout;
    @JsonProperty(value="platform", required=true)
    private PlatformProperties platform;
    @JsonProperty(value="agentConfiguration")
    private AgentProperties agentConfiguration;
    @JsonProperty(value="sourceLocation")
    private String sourceLocation;
    @JsonProperty(value="credentials")
    private Credentials credentials;

    public String taskFilePath() {
        return this.taskFilePath;
    }

    public FileTaskRunRequest withTaskFilePath(String taskFilePath) {
        this.taskFilePath = taskFilePath;
        return this;
    }

    public String valuesFilePath() {
        return this.valuesFilePath;
    }

    public FileTaskRunRequest withValuesFilePath(String valuesFilePath) {
        this.valuesFilePath = valuesFilePath;
        return this;
    }

    public List<SetValue> values() {
        return this.values;
    }

    public FileTaskRunRequest withValues(List<SetValue> values) {
        this.values = values;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public FileTaskRunRequest withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public FileTaskRunRequest withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public FileTaskRunRequest withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceLocation() {
        return this.sourceLocation;
    }

    public FileTaskRunRequest withSourceLocation(String sourceLocation) {
        this.sourceLocation = sourceLocation;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public FileTaskRunRequest withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public FileTaskRunRequest withIsArchiveEnabled(Boolean isArchiveEnabled) {
        super.withIsArchiveEnabled(isArchiveEnabled);
        return this;
    }

    @Override
    public FileTaskRunRequest withAgentPoolName(String agentPoolName) {
        super.withAgentPoolName(agentPoolName);
        return this;
    }

    @Override
    public FileTaskRunRequest withLogTemplate(String logTemplate) {
        super.withLogTemplate(logTemplate);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.taskFilePath() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property taskFilePath in model FileTaskRunRequest"));
        }
        if (this.values() != null) {
            this.values().forEach(e -> e.validate());
        }
        if (this.platform() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property platform in model FileTaskRunRequest"));
        }
        this.platform().validate();
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }
}

