// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerregistry.fluent.models.EventInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The result of a request to list events for a webhook. */
@Fluent
public final class EventListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(EventListResult.class);

    /*
     * The list of events. Since this list may be incomplete, the nextLink
     * field should be used to request the next list of events.
     */
    @JsonProperty(value = "value")
    private List<EventInner> value;

    /*
     * The URI that can be used to request the next list of events.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The list of events. Since this list may be incomplete, the nextLink field should be used
     * to request the next list of events.
     *
     * @return the value value.
     */
    public List<EventInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of events. Since this list may be incomplete, the nextLink field should be used
     * to request the next list of events.
     *
     * @param value the value value to set.
     * @return the EventListResult object itself.
     */
    public EventListResult withValue(List<EventInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI that can be used to request the next list of events.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI that can be used to request the next list of events.
     *
     * @param nextLink the nextLink value to set.
     * @return the EventListResult object itself.
     */
    public EventListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
