// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The QueueStatus of Agent Pool. */
@Fluent
public final class AgentPoolQueueStatusInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AgentPoolQueueStatusInner.class);

    /*
     * The number of pending runs in the queue
     */
    @JsonProperty(value = "count")
    private Integer count;

    /**
     * Get the count property: The number of pending runs in the queue.
     *
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The number of pending runs in the queue.
     *
     * @param count the count value to set.
     * @return the AgentPoolQueueStatusInner object itself.
     */
    public AgentPoolQueueStatusInner withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
