/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIpAddressType;
import com.azure.resourcemanager.containerinstance.models.DnsNameLabelReusePolicy;
import com.azure.resourcemanager.containerinstance.models.Port;
import java.io.IOException;
import java.util.List;

public final class IpAddress
implements JsonSerializable<IpAddress> {
    private List<Port> ports;
    private ContainerGroupIpAddressType type;
    private String ip;
    private String dnsNameLabel;
    private DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope;
    private String fqdn;
    private static final ClientLogger LOGGER = new ClientLogger(IpAddress.class);

    public List<Port> ports() {
        return this.ports;
    }

    public IpAddress withPorts(List<Port> ports) {
        this.ports = ports;
        return this;
    }

    public ContainerGroupIpAddressType type() {
        return this.type;
    }

    public IpAddress withType(ContainerGroupIpAddressType type) {
        this.type = type;
        return this;
    }

    public String ip() {
        return this.ip;
    }

    public IpAddress withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String dnsNameLabel() {
        return this.dnsNameLabel;
    }

    public IpAddress withDnsNameLabel(String dnsNameLabel) {
        this.dnsNameLabel = dnsNameLabel;
        return this;
    }

    public DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    public IpAddress withAutoGeneratedDomainNameLabelScope(DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public void validate() {
        if (this.ports() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ports in model IpAddress"));
        }
        this.ports().forEach(e -> e.validate());
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model IpAddress"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ports", this.ports, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("ip", this.ip);
        jsonWriter.writeStringField("dnsNameLabel", this.dnsNameLabel);
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope", this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpAddress fromJson(JsonReader jsonReader) throws IOException {
        return (IpAddress)jsonReader.readObject(reader -> {
            IpAddress deserializedIpAddress = new IpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ports".equals(fieldName)) {
                    List ports;
                    deserializedIpAddress.ports = ports = reader.readArray(reader1 -> Port.fromJson(reader1));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIpAddress.type = ContainerGroupIpAddressType.fromString(reader.getString());
                    continue;
                }
                if ("ip".equals(fieldName)) {
                    deserializedIpAddress.ip = reader.getString();
                    continue;
                }
                if ("dnsNameLabel".equals(fieldName)) {
                    deserializedIpAddress.dnsNameLabel = reader.getString();
                    continue;
                }
                if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedIpAddress.autoGeneratedDomainNameLabelScope = DnsNameLabelReusePolicy.fromString(reader.getString());
                    continue;
                }
                if ("fqdn".equals(fieldName)) {
                    deserializedIpAddress.fqdn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpAddress;
        });
    }
}

