/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.HttpHeader;
import com.azure.resourcemanager.containerinstance.models.Scheme;
import java.io.IOException;
import java.util.List;

public final class ContainerHttpGet
implements JsonSerializable<ContainerHttpGet> {
    private String path;
    private int port;
    private Scheme scheme;
    private List<HttpHeader> httpHeaders;

    public String path() {
        return this.path;
    }

    public ContainerHttpGet withPath(String path) {
        this.path = path;
        return this;
    }

    public int port() {
        return this.port;
    }

    public ContainerHttpGet withPort(int port) {
        this.port = port;
        return this;
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public ContainerHttpGet withScheme(Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public List<HttpHeader> httpHeaders() {
        return this.httpHeaders;
    }

    public ContainerHttpGet withHttpHeaders(List<HttpHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public void validate() {
        if (this.httpHeaders() != null) {
            this.httpHeaders().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeStringField("path", this.path);
        jsonWriter.writeStringField("scheme", this.scheme == null ? null : this.scheme.toString());
        jsonWriter.writeArrayField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ContainerHttpGet fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerHttpGet)jsonReader.readObject(reader -> {
            ContainerHttpGet deserializedContainerHttpGet = new ContainerHttpGet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("port".equals(fieldName)) {
                    deserializedContainerHttpGet.port = reader.getInt();
                    continue;
                }
                if ("path".equals(fieldName)) {
                    deserializedContainerHttpGet.path = reader.getString();
                    continue;
                }
                if ("scheme".equals(fieldName)) {
                    deserializedContainerHttpGet.scheme = Scheme.fromString(reader.getString());
                    continue;
                }
                if ("httpHeaders".equals(fieldName)) {
                    List httpHeaders;
                    deserializedContainerHttpGet.httpHeaders = httpHeaders = reader.readArray(reader1 -> HttpHeader.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerHttpGet;
        });
    }
}

