/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequestTerminalSize;
import java.io.IOException;

public final class ContainerExecRequest
implements JsonSerializable<ContainerExecRequest> {
    private String command;
    private ContainerExecRequestTerminalSize terminalSize;

    public String command() {
        return this.command;
    }

    public ContainerExecRequest withCommand(String command) {
        this.command = command;
        return this;
    }

    public ContainerExecRequestTerminalSize terminalSize() {
        return this.terminalSize;
    }

    public ContainerExecRequest withTerminalSize(ContainerExecRequestTerminalSize terminalSize) {
        this.terminalSize = terminalSize;
        return this;
    }

    public void validate() {
        if (this.terminalSize() != null) {
            this.terminalSize().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("command", this.command);
        jsonWriter.writeJsonField("terminalSize", (JsonSerializable)this.terminalSize);
        return jsonWriter.writeEndObject();
    }

    public static ContainerExecRequest fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerExecRequest)jsonReader.readObject(reader -> {
            ContainerExecRequest deserializedContainerExecRequest = new ContainerExecRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("command".equals(fieldName)) {
                    deserializedContainerExecRequest.command = reader.getString();
                    continue;
                }
                if ("terminalSize".equals(fieldName)) {
                    deserializedContainerExecRequest.terminalSize = ContainerExecRequestTerminalSize.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerExecRequest;
        });
    }
}

