/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.Resource;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.containerinstance.ContainerInstanceManager;
import com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerExecResponseImpl;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupMsiHandler;
import com.azure.resourcemanager.containerinstance.implementation.ContainerImpl;
import com.azure.resourcemanager.containerinstance.implementation.VolumeImpl;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerAttachResult;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequest;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequestTerminalSize;
import com.azure.resourcemanager.containerinstance.models.ContainerExecResponse;
import com.azure.resourcemanager.containerinstance.models.ContainerGroup;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIpAddressType;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupNetworkProtocol;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.azure.resourcemanager.containerinstance.models.ContainerNetworkProtocol;
import com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.DnsNameLabelReusePolicy;
import com.azure.resourcemanager.containerinstance.models.Event;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.LogAnalytics;
import com.azure.resourcemanager.containerinstance.models.LogAnalyticsLogType;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Port;
import com.azure.resourcemanager.containerinstance.models.ResourceIdentityType;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.Subnet;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.resourcemanager.storage.models.StorageAccountKey;
import com.azure.storage.file.share.ShareServiceAsyncClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ContainerGroupImpl
extends GroupableParentResourceImpl<ContainerGroup, ContainerGroupInner, ContainerGroupImpl, ContainerInstanceManager>
implements ContainerGroup,
ContainerGroup.Definition,
ContainerGroup.Update {
    private final ClientLogger logger = new ClientLogger(ContainerGroupImpl.class);
    private String creatableStorageAccountKey;
    private Creatable<Network> creatableVirtualNetwork;
    private Map<String, String> newFileShares;
    private Map<String, Container> containers;
    private Map<String, Volume> volumes;
    private List<String> imageRegistryServers;
    private int[] externalTcpPorts;
    private int[] externalUdpPorts;
    private ContainerGroupMsiHandler containerGroupMsiHandler = new ContainerGroupMsiHandler(this);

    protected ContainerGroupImpl(String name, ContainerGroupInner innerObject, ContainerInstanceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
        this.initializeChildrenFromInner();
    }

    private Mono<Void> beforeCreation() {
        Mono mono = Mono.empty();
        if (this.creatableVirtualNetwork != null) {
            mono = mono.then(this.creatableVirtualNetwork.createAsync()).flatMap(network -> {
                this.creatableVirtualNetwork = null;
                return Mono.empty();
            });
        }
        return mono;
    }

    protected Mono<ContainerGroupInner> createInner() {
        this.containerGroupMsiHandler.processCreatedExternalIdentities();
        this.containerGroupMsiHandler.handleExternalIdentities();
        ContainerGroupImpl self = this;
        if (!this.isInCreateMode()) {
            Resource resource = new Resource();
            resource.withLocation(self.regionName());
            resource.withTags(self.tags());
            return this.beforeCreation().then(((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().updateAsync(self.resourceGroupName(), self.name(), resource));
        }
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            return this.beforeCreation().then(((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ContainerGroupInner)((Object)this.innerModel())));
        }
        StorageAccount storageAccount = (StorageAccount)this.taskResult(this.creatableStorageAccountKey);
        return this.beforeCreation().thenMany(this.createFileShareAsync(storageAccount)).map(volumeParameters -> this.defineVolume(((VolumeParameters)volumeParameters).volumeName).withExistingReadWriteAzureFileShare(((VolumeParameters)volumeParameters).fileShareName).withStorageAccountName(storageAccount.name()).withStorageAccountKey(((VolumeParameters)volumeParameters).storageAccountKey).attach()).then(((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ContainerGroupInner)((Object)this.innerModel())));
    }

    @Override
    public Accepted<ContainerGroup> beginCreate() {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.name(), (ContainerGroupInner)((Object)((Object)this.innerModel()))).block(), inner -> new ContainerGroupImpl(inner.name(), (ContainerGroupInner)((Object)inner), (ContainerInstanceManager)this.manager()), ContainerGroupInner.class, () -> {
            StorageAccount storageAccount;
            List volumeParametersList;
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.beforeCreation().block();
            this.containerGroupMsiHandler.processCreatedExternalIdentities();
            this.containerGroupMsiHandler.handleExternalIdentities();
            if (this.newFileShares != null && this.creatableStorageAccountKey != null && !CoreUtils.isNullOrEmpty((Collection)(volumeParametersList = (List)this.createFileShareAsync(storageAccount = (StorageAccount)this.taskResult(this.creatableStorageAccountKey)).collectList().block()))) {
                for (VolumeParameters volumeParameters : volumeParametersList) {
                    this.defineVolume(volumeParameters.volumeName).withExistingReadWriteAzureFileShare(volumeParameters.fileShareName).withStorageAccountName(storageAccount.name()).withStorageAccountKey(volumeParameters.storageAccountKey).attach();
                }
            }
        }, (Context)Context.NONE);
    }

    private Flux<VolumeParameters> createFileShareAsync(StorageAccount storageAccount) {
        return storageAccount.getKeysAsync().map(storageAccountKeys -> ((StorageAccountKey)storageAccountKeys.get(0)).value()).flatMapMany(key -> {
            ShareServiceAsyncClient shareServiceAsyncClient = new ShareServiceClientBuilder().connectionString(ResourceManagerUtils.getStorageConnectionString((String)storageAccount.name(), (String)key, (AzureEnvironment)((ContainerInstanceManager)this.manager()).environment())).httpClient(((ContainerInstanceManager)this.manager()).httpPipeline().getHttpClient()).buildAsyncClient();
            Objects.requireNonNull(this.newFileShares);
            return Flux.fromIterable(this.newFileShares.entrySet()).flatMap(fileShareEntry -> this.createSingleFileShareAsync(shareServiceAsyncClient, (String)fileShareEntry.getKey(), (String)fileShareEntry.getValue(), (String)key));
        });
    }

    private Mono<VolumeParameters> createSingleFileShareAsync(ShareServiceAsyncClient client, String volumeName, String fileShareName, String storageAccountKey) {
        return client.createShare(fileShareName).then(Mono.just((Object)new VolumeParameters(volumeName, fileShareName, storageAccountKey)));
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected void initializeChildrenFromInner() {
        this.containers = new HashMap<String, Container>();
        if (((ContainerGroupInner)((Object)this.innerModel())).containers() != null && ((ContainerGroupInner)((Object)this.innerModel())).containers().size() > 0) {
            for (Container containerInstance : ((ContainerGroupInner)((Object)this.innerModel())).containers()) {
                this.containers.put(containerInstance.name(), containerInstance);
                if (containerInstance.ports() == null) continue;
                for (ContainerPort containerPort : containerInstance.ports()) {
                    if (containerPort.protocol() != null) continue;
                    containerPort.withProtocol(ContainerNetworkProtocol.TCP);
                }
            }
        }
        this.volumes = new HashMap<String, Volume>();
        if (((ContainerGroupInner)((Object)this.innerModel())).volumes() != null && ((ContainerGroupInner)((Object)this.innerModel())).volumes().size() > 0) {
            for (Volume volume : ((ContainerGroupInner)((Object)this.innerModel())).volumes()) {
                this.volumes.put(volume.name(), volume);
            }
        }
        this.imageRegistryServers = new ArrayList<String>();
        if (((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials() != null && ((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials().size() > 0) {
            for (ImageRegistryCredential imageRegistry : ((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials()) {
                this.imageRegistryServers.add(imageRegistry.server());
            }
        }
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().ports() != null) {
            int i;
            ArrayList<Port> tcpPorts = new ArrayList<Port>();
            ArrayList<Port> udpPorts = new ArrayList<Port>();
            for (Port port : ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().ports()) {
                if (port.protocol() == null) {
                    port.withProtocol(ContainerGroupNetworkProtocol.TCP);
                }
                if (port.protocol().equals((Object)ContainerGroupNetworkProtocol.TCP)) {
                    tcpPorts.add(port);
                    continue;
                }
                if (!port.protocol().equals((Object)ContainerGroupNetworkProtocol.UDP)) continue;
                udpPorts.add(port);
            }
            this.externalTcpPorts = new int[tcpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
            this.externalUdpPorts = new int[udpPorts.size()];
            for (i = 0; i < this.externalTcpPorts.length; ++i) {
                this.externalTcpPorts[i] = ((Port)tcpPorts.get(i)).port();
            }
        } else {
            this.externalTcpPorts = new int[0];
            this.externalUdpPorts = new int[0];
        }
    }

    public Mono<ContainerGroup> refreshAsync() {
        return super.refreshAsync().map(containerGroup -> {
            ContainerGroupImpl impl = (ContainerGroupImpl)containerGroup;
            impl.initializeChildrenFromInner();
            return impl;
        });
    }

    protected Mono<ContainerGroupInner> getInnerAsync() {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ContainerGroupImpl withLinux() {
        ((ContainerGroupInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX);
        return this;
    }

    @Override
    public ContainerGroupImpl withWindows() {
        ((ContainerGroupInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedManagedServiceIdentity() {
        this.containerGroupMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.containerGroupMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole role) {
        this.containerGroupMsiHandler.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, String roleDefinitionId) {
        this.containerGroupMsiHandler.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public ContainerGroupImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.containerGroupMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public ContainerGroupImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.containerGroupMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public ContainerGroupImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.containerGroupMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public ContainerGroupImpl withPublicImageRegistryOnly() {
        ((ContainerGroupInner)((Object)this.innerModel())).withImageRegistryCredentials(null);
        return this;
    }

    @Override
    public ContainerGroupImpl withPrivateImageRegistry(String server, String username, String password) {
        if (((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withImageRegistryCredentials(new ArrayList<ImageRegistryCredential>());
        }
        ((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials().add(new ImageRegistryCredential().withServer(server).withUsername(username).withPassword(password));
        return this;
    }

    @Override
    public ContainerGroupImpl withPrivateImageRegistry(String server, Identity identity) {
        return this.withPrivateImageRegistry(server, Objects.requireNonNull(identity).id());
    }

    private ContainerGroupImpl withPrivateImageRegistry(String server, String managedIdentityResourceId) {
        if (((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withImageRegistryCredentials(new ArrayList<ImageRegistryCredential>());
        }
        ((ContainerGroupInner)((Object)this.innerModel())).imageRegistryCredentials().add(new ImageRegistryCredential().withServer(server).withIdentity(managedIdentityResourceId));
        return this;
    }

    @Override
    public ContainerGroupImpl withNewAzureFileShareVolume(String volumeName, String shareName) {
        if (this.newFileShares == null || this.creatableStorageAccountKey == null) {
            StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)((ContainerInstanceManager)this.manager()).storageManager().storageAccounts().define(((ContainerInstanceManager)this.manager()).resourceManager().internalContext().randomResourceName("fs", 24))).withRegion(this.regionName());
            Creatable creatable = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKey = this.addDependency(creatable);
            this.newFileShares = new HashMap<String, String>();
        }
        this.newFileShares.put(volumeName, shareName);
        return this;
    }

    @Override
    public ContainerGroupImpl withEmptyDirectoryVolume(String volumeName) {
        if (((ContainerGroupInner)((Object)this.innerModel())).volumes() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withVolumes(new ArrayList<Volume>());
        }
        ((ContainerGroupInner)((Object)this.innerModel())).volumes().add(new Volume().withName(volumeName).withEmptyDir(new Object()));
        return this;
    }

    public VolumeImpl defineVolume(String name) {
        return new VolumeImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withoutVolume() {
        ((ContainerGroupInner)((Object)this.innerModel())).withVolumes(null);
        return this;
    }

    public ContainerImpl defineContainerInstance(String name) {
        return new ContainerImpl(this, name);
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withoutPorts().withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public ContainerGroupImpl withContainerInstance(String imageName, int port) {
        return this.defineContainerInstance(this.name()).withImage(imageName).withExternalTcpPort(port).withCpuCoreCount(1.0).withMemorySizeInGB(1.5).attach();
    }

    @Override
    public ContainerGroupImpl withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        ((ContainerGroupInner)((Object)this.innerModel())).withRestartPolicy(restartPolicy);
        return this;
    }

    @Override
    public ContainerGroupImpl withDnsPrefix(String dnsPrefix) {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withIpAddress(new IpAddress());
        }
        ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().withDnsNameLabel(dnsPrefix).withType(ContainerGroupIpAddressType.PUBLIC);
        return this;
    }

    @Override
    public ContainerGroupImpl withAutoGeneratedDomainNameLabelScope(DnsNameLabelReusePolicy reusePolicy) {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withIpAddress(new IpAddress());
        }
        if (reusePolicy != null) {
            ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().withAutoGeneratedDomainNameLabelScope(reusePolicy);
        }
        return this;
    }

    @Override
    public ContainerGroupImpl withExistingSubnet(Subnet subnet) {
        return this.withExistingSubnet(subnet.id());
    }

    @Override
    public ContainerGroupImpl withExistingSubnet(String subnetId) {
        if (((ContainerGroupInner)((Object)this.innerModel())).subnetIds() == null) {
            ((ContainerGroupInner)((Object)this.innerModel())).withSubnetIds(new ArrayList<ContainerGroupSubnetId>());
        }
        String name = ResourceUtils.nameFromResourceId((String)subnetId);
        ((ContainerGroupInner)((Object)this.innerModel())).subnetIds().add(new ContainerGroupSubnetId().withName(name).withId(subnetId));
        return this;
    }

    @Override
    public ContainerGroupImpl withNewNetworkProfileOnExistingVirtualNetwork(String virtualNetworkId, String subnetName) {
        String subnetId = String.format("%s/subnets/%s", virtualNetworkId, subnetName);
        return this.withExistingSubnet(subnetId);
    }

    @Override
    public ContainerGroupImpl withNewVirtualNetwork(String addressSpace) {
        String virtualNetworkName = ((ContainerInstanceManager)this.manager()).resourceManager().internalContext().randomResourceName("net", 20);
        String subnetName = "subnet0";
        this.creatableVirtualNetwork = (Creatable)((Network.DefinitionStages.WithCreate)((Network.DefinitionStages.WithGroup)((Network.DefinitionStages.Blank)((ContainerInstanceManager)this.manager()).networkManager().networks().define(virtualNetworkName)).withRegion(this.region())).withExistingResourceGroup(this.resourceGroupName())).withAddressSpace(addressSpace).defineSubnet(subnetName).withAddressPrefix(addressSpace).withDelegation("Microsoft.ContainerInstance/containerGroups").attach();
        String virtualNetworkId = String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Network/virtualNetworks/%s", ((ContainerInstanceManager)this.manager()).subscriptionId(), this.resourceGroupName(), virtualNetworkName);
        return this.withNewNetworkProfileOnExistingVirtualNetwork(virtualNetworkId, subnetName);
    }

    @Override
    public ContainerGroupImpl withDnsServerNames(List<String> dnsServerNames) {
        ((ContainerGroupInner)((Object)this.innerModel())).withDnsConfig(new DnsConfiguration().withNameServers(dnsServerNames));
        return this;
    }

    @Override
    public ContainerGroupImpl withDnsConfiguration(List<String> dnsServerNames, String dnsSearchDomains, String dnsOptions) {
        ((ContainerGroupInner)((Object)this.innerModel())).withDnsConfig(new DnsConfiguration().withNameServers(dnsServerNames).withSearchDomains(dnsSearchDomains).withOptions(dnsOptions));
        return this;
    }

    @Override
    public ContainerGroupImpl withLogAnalytics(String workspaceId, String workspaceKey) {
        ((ContainerGroupInner)((Object)this.innerModel())).withDiagnostics(new ContainerGroupDiagnostics().withLogAnalytics(new LogAnalytics().withWorkspaceId(workspaceId).withWorkspaceKey(workspaceKey)));
        return this;
    }

    @Override
    public ContainerGroupImpl withLogAnalytics(String workspaceId, String workspaceKey, LogAnalyticsLogType logType, Map<String, String> metadata) {
        ((ContainerGroupInner)((Object)this.innerModel())).withDiagnostics(new ContainerGroupDiagnostics().withLogAnalytics(new LogAnalytics().withWorkspaceId(workspaceId).withWorkspaceKey(workspaceKey).withLogType(logType).withMetadata(metadata)));
        return this;
    }

    @Override
    public Map<String, Container> containers() {
        return Collections.unmodifiableMap(this.containers);
    }

    @Override
    public Set<Port> externalPorts() {
        return Collections.unmodifiableSet(((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().ports() != null ? new HashSet<Port>(((ContainerGroupInner)((Object)this.innerModel())).ipAddress().ports()) : new HashSet<Port>());
    }

    @Override
    public int[] externalTcpPorts() {
        return (int[])this.externalTcpPorts.clone();
    }

    @Override
    public int[] externalUdpPorts() {
        return (int[])this.externalUdpPorts.clone();
    }

    @Override
    public Map<String, Volume> volumes() {
        return Collections.unmodifiableMap(this.volumes);
    }

    @Override
    public Collection<String> imageRegistryServers() {
        return Collections.unmodifiableCollection(this.imageRegistryServers);
    }

    @Override
    public ContainerGroupRestartPolicy restartPolicy() {
        return ((ContainerGroupInner)((Object)this.innerModel())).restartPolicy();
    }

    @Override
    public String dnsPrefix() {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().dnsNameLabel();
        }
        return null;
    }

    @Override
    public String fqdn() {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().fqdn();
        }
        return null;
    }

    @Override
    public String ipAddress() {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().ip();
        }
        return null;
    }

    @Override
    public boolean isIPAddressPublic() {
        return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().type() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().type() == ContainerGroupIpAddressType.PUBLIC;
    }

    @Override
    public boolean isIPAddressPrivate() {
        return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().type() != null && ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().type() == ContainerGroupIpAddressType.PRIVATE;
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((ContainerGroupInner)((Object)this.innerModel())).osType();
    }

    @Override
    public String state() {
        if (((ContainerGroupInner)((Object)this.innerModel())).instanceView() != null && ((ContainerGroupInner)((Object)this.innerModel())).instanceView().state() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).instanceView().state();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        if (((ContainerGroupInner)((Object)this.innerModel())).provisioningState() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).provisioningState();
        }
        return null;
    }

    @Override
    public Set<Event> events() {
        return Collections.unmodifiableSet(((ContainerGroupInner)((Object)this.innerModel())).instanceView() != null && ((ContainerGroupInner)((Object)this.innerModel())).instanceView().events() != null ? new HashSet<Event>(((ContainerGroupInner)((Object)this.innerModel())).instanceView().events()) : new HashSet<Event>());
    }

    @Override
    public DnsConfiguration dnsConfig() {
        return ((ContainerGroupInner)((Object)this.innerModel())).dnsConfig();
    }

    @Override
    public DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope() {
        if (((ContainerGroupInner)((Object)this.innerModel())).ipAddress() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).ipAddress().autoGeneratedDomainNameLabelScope();
        }
        return null;
    }

    @Override
    public List<ContainerGroupSubnetId> subnetIds() {
        return ((ContainerGroupInner)((Object)this.innerModel())).subnetIds();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((ContainerGroupInner)((Object)this.innerModel())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((ContainerGroupInner)((Object)this.innerModel())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((ContainerGroupInner)((Object)this.innerModel())).identity() != null) {
            return ((ContainerGroupInner)((Object)this.innerModel())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((ContainerGroupInner)((Object)this.innerModel())).identity() != null && ((ContainerGroupInner)((Object)this.innerModel())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((ContainerGroupInner)((Object)this.innerModel())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public LogAnalytics logAnalytics() {
        return ((ContainerGroupInner)((Object)this.innerModel())).diagnostics().logAnalytics();
    }

    @Override
    public void restart() {
        ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().restart(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().restartAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void stop() {
        ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().stop(this.resourceGroupName(), this.name());
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainerGroups().stopAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public String getLogContent(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), this.name(), containerName);
    }

    @Override
    public String getLogContent(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContent(this.resourceGroupName(), this.name(), containerName, tailLineCount);
    }

    @Override
    public Mono<String> getLogContentAsync(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), this.name(), containerName);
    }

    @Override
    public Mono<String> getLogContentAsync(String containerName, int tailLineCount) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().getLogContentAsync(this.resourceGroupName(), this.name(), containerName, tailLineCount);
    }

    @Override
    public ContainerExecResponse executeCommand(String containerName, String command, int row, int column) {
        return (ContainerExecResponse)this.executeCommandAsync(containerName, command, row, column).block();
    }

    @Override
    public Mono<ContainerExecResponse> executeCommandAsync(String containerName, String command, int row, int column) {
        return ((ContainerInstanceManagementClient)((ContainerInstanceManager)this.manager()).serviceClient()).getContainers().executeCommandAsync(this.resourceGroupName(), this.name(), containerName, new ContainerExecRequest().withCommand(command).withTerminalSize(new ContainerExecRequestTerminalSize().withRows(row).withCols(column))).map(ContainerExecResponseImpl::new);
    }

    @Override
    public ContainerAttachResult attachOutputStream(String containerName) {
        return (ContainerAttachResult)this.attachOutputStreamAsync(containerName).block();
    }

    @Override
    public Mono<ContainerAttachResult> attachOutputStreamAsync(String containerName) {
        return ((ContainerInstanceManager)this.manager()).containerGroups().attachOutputStreamAsync(this.resourceGroupName(), this.name(), containerName);
    }

    @Override
    public ContainerAttachResult attachOutputStream(Container container) {
        return (ContainerAttachResult)this.attachOutputStreamAsync(container).block();
    }

    @Override
    public Mono<ContainerAttachResult> attachOutputStreamAsync(Container container) {
        return this.attachOutputStreamAsync(container.name());
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (ContainerGroupImpl.this.innerModel() != null && ((ContainerGroupInner)((Object)ContainerGroupImpl.this.innerModel())).identity() != null) {
                    return ((ContainerGroupInner)((Object)ContainerGroupImpl.this.innerModel())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (ContainerGroupImpl.this.innerModel() != null) {
                    return ((ContainerGroupInner)((Object)ContainerGroupImpl.this.innerModel())).id();
                }
                return null;
            }
        };
    }

    private static final class VolumeParameters {
        private final String volumeName;
        private final String fileShareName;
        private final String storageAccountKey;

        VolumeParameters(String volumeName, String fileShareName, String storageAccountKey) {
            this.volumeName = volumeName;
            this.fileShareName = fileShareName;
            this.storageAccountKey = storageAccountKey;
        }
    }
}

