/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DeploymentExtensionSpecProperties
implements JsonSerializable<DeploymentExtensionSpecProperties> {
    private String extensionType;
    private String version;
    private Object settings;
    private Object protectedSettings;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExtensionSpecProperties.class);

    public String extensionType() {
        return this.extensionType;
    }

    public DeploymentExtensionSpecProperties withExtensionType(String extensionType) {
        this.extensionType = extensionType;
        return this;
    }

    public String version() {
        return this.version;
    }

    public DeploymentExtensionSpecProperties withVersion(String version) {
        this.version = version;
        return this;
    }

    public Object settings() {
        return this.settings;
    }

    public DeploymentExtensionSpecProperties withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Object protectedSettings() {
        return this.protectedSettings;
    }

    public DeploymentExtensionSpecProperties withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public void validate() {
        if (this.extensionType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extensionType in model DeploymentExtensionSpecProperties"));
        }
        if (this.version() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property version in model DeploymentExtensionSpecProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("extensionType", this.extensionType);
        jsonWriter.writeStringField("version", this.version);
        jsonWriter.writeUntypedField("settings", this.settings);
        jsonWriter.writeUntypedField("protectedSettings", this.protectedSettings);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentExtensionSpecProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentExtensionSpecProperties)jsonReader.readObject(reader -> {
            DeploymentExtensionSpecProperties deserializedDeploymentExtensionSpecProperties = new DeploymentExtensionSpecProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extensionType".equals(fieldName)) {
                    deserializedDeploymentExtensionSpecProperties.extensionType = reader.getString();
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedDeploymentExtensionSpecProperties.version = reader.getString();
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedDeploymentExtensionSpecProperties.settings = reader.readUntyped();
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    deserializedDeploymentExtensionSpecProperties.protectedSettings = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentExtensionSpecProperties;
        });
    }
}

