/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ContainerState
implements JsonSerializable<ContainerState> {
    private String state;
    private OffsetDateTime startTime;
    private Integer exitCode;
    private OffsetDateTime finishTime;
    private String detailStatus;

    public String state() {
        return this.state;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public OffsetDateTime finishTime() {
        return this.finishTime;
    }

    public String detailStatus() {
        return this.detailStatus;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ContainerState fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerState)jsonReader.readObject(reader -> {
            ContainerState deserializedContainerState = new ContainerState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedContainerState.state = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedContainerState.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("exitCode".equals(fieldName)) {
                    deserializedContainerState.exitCode = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("finishTime".equals(fieldName)) {
                    deserializedContainerState.finishTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("detailStatus".equals(fieldName)) {
                    deserializedContainerState.detailStatus = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerState;
        });
    }
}

