// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The security context for the container.
 */
@Fluent
public final class SecurityContextDefinition implements JsonSerializable<SecurityContextDefinition> {
    /*
     * The flag to determine if the container permissions is elevated to Privileged.
     */
    private Boolean privileged;

    /*
     * A boolean value indicating whether the init process can elevate its privileges
     */
    private Boolean allowPrivilegeEscalation;

    /*
     * The capabilities to add or drop from a container.
     */
    private SecurityContextCapabilitiesDefinition capabilities;

    /*
     * Sets the User GID for the container.
     */
    private Integer runAsGroup;

    /*
     * Sets the User UID for the container.
     */
    private Integer runAsUser;

    /*
     * a base64 encoded string containing the contents of the JSON in the seccomp profile
     */
    private String seccompProfile;

    /**
     * Creates an instance of SecurityContextDefinition class.
     */
    public SecurityContextDefinition() {
    }

    /**
     * Get the privileged property: The flag to determine if the container permissions is elevated to Privileged.
     * 
     * @return the privileged value.
     */
    public Boolean privileged() {
        return this.privileged;
    }

    /**
     * Set the privileged property: The flag to determine if the container permissions is elevated to Privileged.
     * 
     * @param privileged the privileged value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    /**
     * Get the allowPrivilegeEscalation property: A boolean value indicating whether the init process can elevate its
     * privileges.
     * 
     * @return the allowPrivilegeEscalation value.
     */
    public Boolean allowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    /**
     * Set the allowPrivilegeEscalation property: A boolean value indicating whether the init process can elevate its
     * privileges.
     * 
     * @param allowPrivilegeEscalation the allowPrivilegeEscalation value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    /**
     * Get the capabilities property: The capabilities to add or drop from a container.
     * 
     * @return the capabilities value.
     */
    public SecurityContextCapabilitiesDefinition capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: The capabilities to add or drop from a container.
     * 
     * @param capabilities the capabilities value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withCapabilities(SecurityContextCapabilitiesDefinition capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the runAsGroup property: Sets the User GID for the container.
     * 
     * @return the runAsGroup value.
     */
    public Integer runAsGroup() {
        return this.runAsGroup;
    }

    /**
     * Set the runAsGroup property: Sets the User GID for the container.
     * 
     * @param runAsGroup the runAsGroup value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withRunAsGroup(Integer runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    /**
     * Get the runAsUser property: Sets the User UID for the container.
     * 
     * @return the runAsUser value.
     */
    public Integer runAsUser() {
        return this.runAsUser;
    }

    /**
     * Set the runAsUser property: Sets the User UID for the container.
     * 
     * @param runAsUser the runAsUser value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withRunAsUser(Integer runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    /**
     * Get the seccompProfile property: a base64 encoded string containing the contents of the JSON in the seccomp
     * profile.
     * 
     * @return the seccompProfile value.
     */
    public String seccompProfile() {
        return this.seccompProfile;
    }

    /**
     * Set the seccompProfile property: a base64 encoded string containing the contents of the JSON in the seccomp
     * profile.
     * 
     * @param seccompProfile the seccompProfile value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withSeccompProfile(String seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("privileged", this.privileged);
        jsonWriter.writeBooleanField("allowPrivilegeEscalation", this.allowPrivilegeEscalation);
        jsonWriter.writeJsonField("capabilities", this.capabilities);
        jsonWriter.writeNumberField("runAsGroup", this.runAsGroup);
        jsonWriter.writeNumberField("runAsUser", this.runAsUser);
        jsonWriter.writeStringField("seccompProfile", this.seccompProfile);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityContextDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityContextDefinition if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityContextDefinition.
     */
    public static SecurityContextDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityContextDefinition deserializedSecurityContextDefinition = new SecurityContextDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privileged".equals(fieldName)) {
                    deserializedSecurityContextDefinition.privileged = reader.getNullable(JsonReader::getBoolean);
                } else if ("allowPrivilegeEscalation".equals(fieldName)) {
                    deserializedSecurityContextDefinition.allowPrivilegeEscalation
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("capabilities".equals(fieldName)) {
                    deserializedSecurityContextDefinition.capabilities
                        = SecurityContextCapabilitiesDefinition.fromJson(reader);
                } else if ("runAsGroup".equals(fieldName)) {
                    deserializedSecurityContextDefinition.runAsGroup = reader.getNullable(JsonReader::getInt);
                } else if ("runAsUser".equals(fieldName)) {
                    deserializedSecurityContextDefinition.runAsUser = reader.getNullable(JsonReader::getInt);
                } else if ("seccompProfile".equals(fieldName)) {
                    deserializedSecurityContextDefinition.seccompProfile = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityContextDefinition;
        });
    }
}
