// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The capabilities to add or drop from a container.
 */
@Fluent
public final class SecurityContextCapabilitiesDefinition
    implements JsonSerializable<SecurityContextCapabilitiesDefinition> {
    /*
     * The capabilities to add to the container.
     */
    private List<String> add;

    /*
     * The capabilities to drop from the container.
     */
    private List<String> drop;

    /**
     * Creates an instance of SecurityContextCapabilitiesDefinition class.
     */
    public SecurityContextCapabilitiesDefinition() {
    }

    /**
     * Get the add property: The capabilities to add to the container.
     * 
     * @return the add value.
     */
    public List<String> add() {
        return this.add;
    }

    /**
     * Set the add property: The capabilities to add to the container.
     * 
     * @param add the add value to set.
     * @return the SecurityContextCapabilitiesDefinition object itself.
     */
    public SecurityContextCapabilitiesDefinition withAdd(List<String> add) {
        this.add = add;
        return this;
    }

    /**
     * Get the drop property: The capabilities to drop from the container.
     * 
     * @return the drop value.
     */
    public List<String> drop() {
        return this.drop;
    }

    /**
     * Set the drop property: The capabilities to drop from the container.
     * 
     * @param drop the drop value to set.
     * @return the SecurityContextCapabilitiesDefinition object itself.
     */
    public SecurityContextCapabilitiesDefinition withDrop(List<String> drop) {
        this.drop = drop;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("add", this.add, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("drop", this.drop, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityContextCapabilitiesDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityContextCapabilitiesDefinition if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityContextCapabilitiesDefinition.
     */
    public static SecurityContextCapabilitiesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityContextCapabilitiesDefinition deserializedSecurityContextCapabilitiesDefinition
                = new SecurityContextCapabilitiesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("add".equals(fieldName)) {
                    List<String> add = reader.readArray(reader1 -> reader1.getString());
                    deserializedSecurityContextCapabilitiesDefinition.add = add;
                } else if ("drop".equals(fieldName)) {
                    List<String> drop = reader.readArray(reader1 -> reader1.getString());
                    deserializedSecurityContextCapabilitiesDefinition.drop = drop;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityContextCapabilitiesDefinition;
        });
    }
}
