// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The priority of the container group.
 */
public final class ContainerGroupPriority extends ExpandableStringEnum<ContainerGroupPriority> {
    /**
     * Static value Regular for ContainerGroupPriority.
     */
    public static final ContainerGroupPriority REGULAR = fromString("Regular");

    /**
     * Static value Spot for ContainerGroupPriority.
     */
    public static final ContainerGroupPriority SPOT = fromString("Spot");

    /**
     * Creates a new instance of ContainerGroupPriority value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContainerGroupPriority() {
    }

    /**
     * Creates or finds a ContainerGroupPriority from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContainerGroupPriority.
     */
    public static ContainerGroupPriority fromString(String name) {
        return fromString(name, ContainerGroupPriority.class);
    }

    /**
     * Gets known ContainerGroupPriority values.
     * 
     * @return known ContainerGroupPriority values.
     */
    public static Collection<ContainerGroupPriority> values() {
        return values(ContainerGroupPriority.class);
    }
}
