// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * The container group list response that contains the container group properties.
 */
@Fluent
public final class ContainerGroupListResult implements JsonSerializable<ContainerGroupListResult> {
    /*
     * The list of container groups.
     */
    private List<ContainerGroupInner> value;

    /*
     * The URI to fetch the next page of container groups.
     */
    private String nextLink;

    /**
     * Creates an instance of ContainerGroupListResult class.
     */
    public ContainerGroupListResult() {
    }

    /**
     * Get the value property: The list of container groups.
     * 
     * @return the value value.
     */
    public List<ContainerGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of container groups.
     * 
     * @param value the value value to set.
     * @return the ContainerGroupListResult object itself.
     */
    public ContainerGroupListResult withValue(List<ContainerGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of container groups.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of container groups.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ContainerGroupListResult object itself.
     */
    public ContainerGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerGroupListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerGroupListResult.
     */
    public static ContainerGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupListResult deserializedContainerGroupListResult = new ContainerGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ContainerGroupInner> value
                        = reader.readArray(reader1 -> ContainerGroupInner.fromJson(reader1));
                    deserializedContainerGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedContainerGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerGroupListResult;
        });
    }
}
