// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The list of user identities associated with the container group. The user identity dictionary key references will be
 * ARM resource ids in the form:
 * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
@Immutable
public final class ContainerGroupIdentityUserAssignedIdentities
    implements JsonSerializable<ContainerGroupIdentityUserAssignedIdentities> {
    /*
     * The principal id of user assigned identity.
     */
    private String principalId;

    /*
     * The client id of user assigned identity.
     */
    private String clientId;

    /**
     * Creates an instance of ContainerGroupIdentityUserAssignedIdentities class.
     */
    public ContainerGroupIdentityUserAssignedIdentities() {
    }

    /**
     * Get the principalId property: The principal id of user assigned identity.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the clientId property: The client id of user assigned identity.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerGroupIdentityUserAssignedIdentities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerGroupIdentityUserAssignedIdentities if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerGroupIdentityUserAssignedIdentities.
     */
    public static ContainerGroupIdentityUserAssignedIdentities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupIdentityUserAssignedIdentities deserializedContainerGroupIdentityUserAssignedIdentities
                = new ContainerGroupIdentityUserAssignedIdentities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedContainerGroupIdentityUserAssignedIdentities.principalId = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedContainerGroupIdentityUserAssignedIdentities.clientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerGroupIdentityUserAssignedIdentities;
        });
    }
}
