/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.GpuSku;
import java.io.IOException;

public final class GpuResource
implements JsonSerializable<GpuResource> {
    private int count;
    private GpuSku sku;
    private static final ClientLogger LOGGER = new ClientLogger(GpuResource.class);

    public int count() {
        return this.count;
    }

    public GpuResource withCount(int count) {
        this.count = count;
        return this;
    }

    public GpuSku sku() {
        return this.sku;
    }

    public GpuResource withSku(GpuSku sku) {
        this.sku = sku;
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sku in model GpuResource"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("count", this.count);
        jsonWriter.writeStringField("sku", this.sku == null ? null : this.sku.toString());
        return jsonWriter.writeEndObject();
    }

    public static GpuResource fromJson(JsonReader jsonReader) throws IOException {
        return (GpuResource)jsonReader.readObject(reader -> {
            GpuResource deserializedGpuResource = new GpuResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedGpuResource.count = reader.getInt();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedGpuResource.sku = GpuSku.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGpuResource;
        });
    }
}

