/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VolumeMount
implements JsonSerializable<VolumeMount> {
    private String name;
    private String mountPath;
    private Boolean readOnly;
    private static final ClientLogger LOGGER = new ClientLogger(VolumeMount.class);

    public String name() {
        return this.name;
    }

    public VolumeMount withName(String name) {
        this.name = name;
        return this;
    }

    public String mountPath() {
        return this.mountPath;
    }

    public VolumeMount withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    public Boolean readOnly() {
        return this.readOnly;
    }

    public VolumeMount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model VolumeMount"));
        }
        if (this.mountPath() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mountPath in model VolumeMount"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        return jsonWriter.writeEndObject();
    }

    public static VolumeMount fromJson(JsonReader jsonReader) throws IOException {
        return (VolumeMount)jsonReader.readObject(reader -> {
            VolumeMount deserializedVolumeMount = new VolumeMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVolumeMount.name = reader.getString();
                    continue;
                }
                if ("mountPath".equals(fieldName)) {
                    deserializedVolumeMount.mountPath = reader.getString();
                    continue;
                }
                if ("readOnly".equals(fieldName)) {
                    deserializedVolumeMount.readOnly = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolumeMount;
        });
    }
}

