// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties of the volume mount.
 */
@Fluent
public final class VolumeMount implements JsonSerializable<VolumeMount> {
    /*
     * The name of the volume mount.
     */
    private String name;

    /*
     * The path within the container where the volume should be mounted. Must not contain colon (:).
     */
    private String mountPath;

    /*
     * The flag indicating whether the volume mount is read-only.
     */
    private Boolean readOnly;

    /**
     * Creates an instance of VolumeMount class.
     */
    public VolumeMount() {
    }

    /**
     * Get the name property: The name of the volume mount.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the volume mount.
     * 
     * @param name the name value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the mountPath property: The path within the container where the volume should be mounted. Must not contain
     * colon (:).
     * 
     * @return the mountPath value.
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath property: The path within the container where the volume should be mounted. Must not contain
     * colon (:).
     * 
     * @param mountPath the mountPath value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Get the readOnly property: The flag indicating whether the volume mount is read-only.
     * 
     * @return the readOnly value.
     */
    public Boolean readOnly() {
        return this.readOnly;
    }

    /**
     * Set the readOnly property: The flag indicating whether the volume mount is read-only.
     * 
     * @param readOnly the readOnly value to set.
     * @return the VolumeMount object itself.
     */
    public VolumeMount withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model VolumeMount"));
        }
        if (mountPath() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property mountPath in model VolumeMount"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(VolumeMount.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeBooleanField("readOnly", this.readOnly);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VolumeMount from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VolumeMount if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VolumeMount.
     */
    public static VolumeMount fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VolumeMount deserializedVolumeMount = new VolumeMount();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedVolumeMount.name = reader.getString();
                } else if ("mountPath".equals(fieldName)) {
                    deserializedVolumeMount.mountPath = reader.getString();
                } else if ("readOnly".equals(fieldName)) {
                    deserializedVolumeMount.readOnly = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVolumeMount;
        });
    }
}
