// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * DNS configuration for the container group.
 */
@Fluent
public final class DnsConfiguration implements JsonSerializable<DnsConfiguration> {
    /*
     * The DNS servers for the container group.
     */
    private List<String> nameServers;

    /*
     * The DNS search domains for hostname lookup in the container group.
     */
    private String searchDomains;

    /*
     * The DNS options for the container group.
     */
    private String options;

    /**
     * Creates an instance of DnsConfiguration class.
     */
    public DnsConfiguration() {
    }

    /**
     * Get the nameServers property: The DNS servers for the container group.
     * 
     * @return the nameServers value.
     */
    public List<String> nameServers() {
        return this.nameServers;
    }

    /**
     * Set the nameServers property: The DNS servers for the container group.
     * 
     * @param nameServers the nameServers value to set.
     * @return the DnsConfiguration object itself.
     */
    public DnsConfiguration withNameServers(List<String> nameServers) {
        this.nameServers = nameServers;
        return this;
    }

    /**
     * Get the searchDomains property: The DNS search domains for hostname lookup in the container group.
     * 
     * @return the searchDomains value.
     */
    public String searchDomains() {
        return this.searchDomains;
    }

    /**
     * Set the searchDomains property: The DNS search domains for hostname lookup in the container group.
     * 
     * @param searchDomains the searchDomains value to set.
     * @return the DnsConfiguration object itself.
     */
    public DnsConfiguration withSearchDomains(String searchDomains) {
        this.searchDomains = searchDomains;
        return this;
    }

    /**
     * Get the options property: The DNS options for the container group.
     * 
     * @return the options value.
     */
    public String options() {
        return this.options;
    }

    /**
     * Set the options property: The DNS options for the container group.
     * 
     * @param options the options value to set.
     * @return the DnsConfiguration object itself.
     */
    public DnsConfiguration withOptions(String options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nameServers() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property nameServers in model DnsConfiguration"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DnsConfiguration.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nameServers", this.nameServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("searchDomains", this.searchDomains);
        jsonWriter.writeStringField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DnsConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DnsConfiguration if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DnsConfiguration.
     */
    public static DnsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DnsConfiguration deserializedDnsConfiguration = new DnsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nameServers".equals(fieldName)) {
                    List<String> nameServers = reader.readArray(reader1 -> reader1.getString());
                    deserializedDnsConfiguration.nameServers = nameServers;
                } else if ("searchDomains".equals(fieldName)) {
                    deserializedDnsConfiguration.searchDomains = reader.getString();
                } else if ("options".equals(fieldName)) {
                    deserializedDnsConfiguration.options = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDnsConfiguration;
        });
    }
}
