// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ConfidentialComputeProperties;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPriority;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.azure.resourcemanager.containerinstance.models.DeploymentExtensionSpec;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Volume;
import java.io.IOException;
import java.util.List;

/**
 * The container group properties.
 */
@Fluent
public final class ContainerGroupProperties implements JsonSerializable<ContainerGroupProperties> {
    /*
     * The provisioning state of the container group. This only appears in the response.
     */
    private String provisioningState;

    /*
     * The containers within the container group.
     */
    private List<Container> containers;

    /*
     * The image registry credentials by which the container group is created from.
     */
    private List<ImageRegistryCredential> imageRegistryCredentials;

    /*
     * Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart
     */
    private ContainerGroupRestartPolicy restartPolicy;

    /*
     * The IP address type of the container group.
     */
    private IpAddress ipAddress;

    /*
     * The operating system type required by the containers in the container group.
     */
    private OperatingSystemTypes osType;

    /*
     * The list of volumes that can be mounted by containers in this container group.
     */
    private List<Volume> volumes;

    /*
     * The instance view of the container group. Only valid in response.
     */
    private ContainerGroupPropertiesInstanceView instanceView;

    /*
     * The diagnostic information for a container group.
     */
    private ContainerGroupDiagnostics diagnostics;

    /*
     * The subnet resource IDs for a container group.
     */
    private List<ContainerGroupSubnetId> subnetIds;

    /*
     * The DNS config information for a container group.
     */
    private DnsConfiguration dnsConfig;

    /*
     * The SKU for a container group.
     */
    private ContainerGroupSku sku;

    /*
     * The encryption properties for a container group.
     */
    private EncryptionProperties encryptionProperties;

    /*
     * The init containers for a container group.
     */
    private List<InitContainerDefinition> initContainers;

    /*
     * extensions used by virtual kubelet
     */
    private List<DeploymentExtensionSpec> extensions;

    /*
     * The properties for confidential container group
     */
    private ConfidentialComputeProperties confidentialComputeProperties;

    /*
     * The priority of the container group.
     */
    private ContainerGroupPriority priority;

    /**
     * Creates an instance of ContainerGroupProperties class.
     */
    public ContainerGroupProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the container group. This only appears in the
     * response.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the containers property: The containers within the container group.
     * 
     * @return the containers value.
     */
    public List<Container> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: The containers within the container group.
     * 
     * @param containers the containers value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the imageRegistryCredentials property: The image registry credentials by which the container group is created
     * from.
     * 
     * @return the imageRegistryCredentials value.
     */
    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.imageRegistryCredentials;
    }

    /**
     * Set the imageRegistryCredentials property: The image registry credentials by which the container group is created
     * from.
     * 
     * @param imageRegistryCredentials the imageRegistryCredentials value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties
        withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        this.imageRegistryCredentials = imageRegistryCredentials;
        return this;
    }

    /**
     * Get the restartPolicy property: Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart.
     * 
     * @return the restartPolicy value.
     */
    public ContainerGroupRestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    /**
     * Set the restartPolicy property: Restart policy for all containers within the container group.
     * - `Always` Always restart
     * - `OnFailure` Restart on failure
     * - `Never` Never restart.
     * 
     * @param restartPolicy the restartPolicy value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    /**
     * Get the ipAddress property: The IP address type of the container group.
     * 
     * @return the ipAddress value.
     */
    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address type of the container group.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withIpAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the osType property: The operating system type required by the containers in the container group.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The operating system type required by the containers in the container group.
     * 
     * @param osType the osType value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the volumes property: The list of volumes that can be mounted by containers in this container group.
     * 
     * @return the volumes value.
     */
    public List<Volume> volumes() {
        return this.volumes;
    }

    /**
     * Set the volumes property: The list of volumes that can be mounted by containers in this container group.
     * 
     * @param volumes the volumes value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    /**
     * Get the instanceView property: The instance view of the container group. Only valid in response.
     * 
     * @return the instanceView value.
     */
    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the diagnostics property: The diagnostic information for a container group.
     * 
     * @return the diagnostics value.
     */
    public ContainerGroupDiagnostics diagnostics() {
        return this.diagnostics;
    }

    /**
     * Set the diagnostics property: The diagnostic information for a container group.
     * 
     * @param diagnostics the diagnostics value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    /**
     * Get the subnetIds property: The subnet resource IDs for a container group.
     * 
     * @return the subnetIds value.
     */
    public List<ContainerGroupSubnetId> subnetIds() {
        return this.subnetIds;
    }

    /**
     * Set the subnetIds property: The subnet resource IDs for a container group.
     * 
     * @param subnetIds the subnetIds value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        this.subnetIds = subnetIds;
        return this;
    }

    /**
     * Get the dnsConfig property: The DNS config information for a container group.
     * 
     * @return the dnsConfig value.
     */
    public DnsConfiguration dnsConfig() {
        return this.dnsConfig;
    }

    /**
     * Set the dnsConfig property: The DNS config information for a container group.
     * 
     * @param dnsConfig the dnsConfig value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withDnsConfig(DnsConfiguration dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    /**
     * Get the sku property: The SKU for a container group.
     * 
     * @return the sku value.
     */
    public ContainerGroupSku sku() {
        return this.sku;
    }

    /**
     * Set the sku property: The SKU for a container group.
     * 
     * @param sku the sku value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withSku(ContainerGroupSku sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the encryptionProperties property: The encryption properties for a container group.
     * 
     * @return the encryptionProperties value.
     */
    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    /**
     * Set the encryptionProperties property: The encryption properties for a container group.
     * 
     * @param encryptionProperties the encryptionProperties value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    /**
     * Get the initContainers property: The init containers for a container group.
     * 
     * @return the initContainers value.
     */
    public List<InitContainerDefinition> initContainers() {
        return this.initContainers;
    }

    /**
     * Set the initContainers property: The init containers for a container group.
     * 
     * @param initContainers the initContainers value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withInitContainers(List<InitContainerDefinition> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    /**
     * Get the extensions property: extensions used by virtual kubelet.
     * 
     * @return the extensions value.
     */
    public List<DeploymentExtensionSpec> extensions() {
        return this.extensions;
    }

    /**
     * Set the extensions property: extensions used by virtual kubelet.
     * 
     * @param extensions the extensions value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withExtensions(List<DeploymentExtensionSpec> extensions) {
        this.extensions = extensions;
        return this;
    }

    /**
     * Get the confidentialComputeProperties property: The properties for confidential container group.
     * 
     * @return the confidentialComputeProperties value.
     */
    public ConfidentialComputeProperties confidentialComputeProperties() {
        return this.confidentialComputeProperties;
    }

    /**
     * Set the confidentialComputeProperties property: The properties for confidential container group.
     * 
     * @param confidentialComputeProperties the confidentialComputeProperties value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties
        withConfidentialComputeProperties(ConfidentialComputeProperties confidentialComputeProperties) {
        this.confidentialComputeProperties = confidentialComputeProperties;
        return this;
    }

    /**
     * Get the priority property: The priority of the container group.
     * 
     * @return the priority value.
     */
    public ContainerGroupPriority priority() {
        return this.priority;
    }

    /**
     * Set the priority property: The priority of the container group.
     * 
     * @param priority the priority value to set.
     * @return the ContainerGroupProperties object itself.
     */
    public ContainerGroupProperties withPriority(ContainerGroupPriority priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containers() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property containers in model ContainerGroupProperties"));
        } else {
            containers().forEach(e -> e.validate());
        }
        if (imageRegistryCredentials() != null) {
            imageRegistryCredentials().forEach(e -> e.validate());
        }
        if (ipAddress() != null) {
            ipAddress().validate();
        }
        if (osType() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property osType in model ContainerGroupProperties"));
        }
        if (volumes() != null) {
            volumes().forEach(e -> e.validate());
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
        if (diagnostics() != null) {
            diagnostics().validate();
        }
        if (subnetIds() != null) {
            subnetIds().forEach(e -> e.validate());
        }
        if (dnsConfig() != null) {
            dnsConfig().validate();
        }
        if (encryptionProperties() != null) {
            encryptionProperties().validate();
        }
        if (initContainers() != null) {
            initContainers().forEach(e -> e.validate());
        }
        if (extensions() != null) {
            extensions().forEach(e -> e.validate());
        }
        if (confidentialComputeProperties() != null) {
            confidentialComputeProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeArrayField("imageRegistryCredentials", this.imageRegistryCredentials,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("restartPolicy", this.restartPolicy == null ? null : this.restartPolicy.toString());
        jsonWriter.writeJsonField("ipAddress", this.ipAddress);
        jsonWriter.writeArrayField("volumes", this.volumes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("diagnostics", this.diagnostics);
        jsonWriter.writeArrayField("subnetIds", this.subnetIds, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("dnsConfig", this.dnsConfig);
        jsonWriter.writeStringField("sku", this.sku == null ? null : this.sku.toString());
        jsonWriter.writeJsonField("encryptionProperties", this.encryptionProperties);
        jsonWriter.writeArrayField("initContainers", this.initContainers,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("confidentialComputeProperties", this.confidentialComputeProperties);
        jsonWriter.writeStringField("priority", this.priority == null ? null : this.priority.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerGroupProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerGroupProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerGroupProperties.
     */
    public static ContainerGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupProperties deserializedContainerGroupProperties = new ContainerGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("containers".equals(fieldName)) {
                    List<Container> containers = reader.readArray(reader1 -> Container.fromJson(reader1));
                    deserializedContainerGroupProperties.containers = containers;
                } else if ("osType".equals(fieldName)) {
                    deserializedContainerGroupProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedContainerGroupProperties.provisioningState = reader.getString();
                } else if ("imageRegistryCredentials".equals(fieldName)) {
                    List<ImageRegistryCredential> imageRegistryCredentials
                        = reader.readArray(reader1 -> ImageRegistryCredential.fromJson(reader1));
                    deserializedContainerGroupProperties.imageRegistryCredentials = imageRegistryCredentials;
                } else if ("restartPolicy".equals(fieldName)) {
                    deserializedContainerGroupProperties.restartPolicy
                        = ContainerGroupRestartPolicy.fromString(reader.getString());
                } else if ("ipAddress".equals(fieldName)) {
                    deserializedContainerGroupProperties.ipAddress = IpAddress.fromJson(reader);
                } else if ("volumes".equals(fieldName)) {
                    List<Volume> volumes = reader.readArray(reader1 -> Volume.fromJson(reader1));
                    deserializedContainerGroupProperties.volumes = volumes;
                } else if ("instanceView".equals(fieldName)) {
                    deserializedContainerGroupProperties.instanceView
                        = ContainerGroupPropertiesInstanceView.fromJson(reader);
                } else if ("diagnostics".equals(fieldName)) {
                    deserializedContainerGroupProperties.diagnostics = ContainerGroupDiagnostics.fromJson(reader);
                } else if ("subnetIds".equals(fieldName)) {
                    List<ContainerGroupSubnetId> subnetIds
                        = reader.readArray(reader1 -> ContainerGroupSubnetId.fromJson(reader1));
                    deserializedContainerGroupProperties.subnetIds = subnetIds;
                } else if ("dnsConfig".equals(fieldName)) {
                    deserializedContainerGroupProperties.dnsConfig = DnsConfiguration.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedContainerGroupProperties.sku = ContainerGroupSku.fromString(reader.getString());
                } else if ("encryptionProperties".equals(fieldName)) {
                    deserializedContainerGroupProperties.encryptionProperties = EncryptionProperties.fromJson(reader);
                } else if ("initContainers".equals(fieldName)) {
                    List<InitContainerDefinition> initContainers
                        = reader.readArray(reader1 -> InitContainerDefinition.fromJson(reader1));
                    deserializedContainerGroupProperties.initContainers = initContainers;
                } else if ("extensions".equals(fieldName)) {
                    List<DeploymentExtensionSpec> extensions
                        = reader.readArray(reader1 -> DeploymentExtensionSpec.fromJson(reader1));
                    deserializedContainerGroupProperties.extensions = extensions;
                } else if ("confidentialComputeProperties".equals(fieldName)) {
                    deserializedContainerGroupProperties.confidentialComputeProperties
                        = ConfidentialComputeProperties.fromJson(reader);
                } else if ("priority".equals(fieldName)) {
                    deserializedContainerGroupProperties.priority
                        = ContainerGroupPriority.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerGroupProperties;
        });
    }
}
