// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * IP address for the container group.
 */
@Fluent
public final class IpAddress implements JsonSerializable<IpAddress> {
    /*
     * The list of ports exposed on the container group.
     */
    private List<Port> ports;

    /*
     * Specifies if the IP is exposed to the public internet or private VNET.
     */
    private ContainerGroupIpAddressType type;

    /*
     * The IP exposed to the public internet.
     */
    private String ip;

    /*
     * The Dns name label for the IP.
     */
    private String dnsNameLabel;

    /*
     * The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the
     * object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default
     * value if selected and means the object's domain name label can be reused within the same tenant. The
     * 'SubscriptionReuse' value means the object's domain name label can be reused within the same subscription. The
     * 'ResourceGroupReuse' value means the object's domain name label can be reused within the same resource group. The
     * 'NoReuse' value means the object's domain name label cannot be reused within the same resource group,
     * subscription, or tenant.
     */
    private DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope;

    /*
     * The FQDN for the IP.
     */
    private String fqdn;

    /**
     * Creates an instance of IpAddress class.
     */
    public IpAddress() {
    }

    /**
     * Get the ports property: The list of ports exposed on the container group.
     * 
     * @return the ports value.
     */
    public List<Port> ports() {
        return this.ports;
    }

    /**
     * Set the ports property: The list of ports exposed on the container group.
     * 
     * @param ports the ports value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withPorts(List<Port> ports) {
        this.ports = ports;
        return this;
    }

    /**
     * Get the type property: Specifies if the IP is exposed to the public internet or private VNET.
     * 
     * @return the type value.
     */
    public ContainerGroupIpAddressType type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies if the IP is exposed to the public internet or private VNET.
     * 
     * @param type the type value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withType(ContainerGroupIpAddressType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the ip property: The IP exposed to the public internet.
     * 
     * @return the ip value.
     */
    public String ip() {
        return this.ip;
    }

    /**
     * Set the ip property: The IP exposed to the public internet.
     * 
     * @param ip the ip value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withIp(String ip) {
        this.ip = ip;
        return this;
    }

    /**
     * Get the dnsNameLabel property: The Dns name label for the IP.
     * 
     * @return the dnsNameLabel value.
     */
    public String dnsNameLabel() {
        return this.dnsNameLabel;
    }

    /**
     * Set the dnsNameLabel property: The Dns name label for the IP.
     * 
     * @param dnsNameLabel the dnsNameLabel value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withDnsNameLabel(String dnsNameLabel) {
        this.dnsNameLabel = dnsNameLabel;
        return this;
    }

    /**
     * Get the autoGeneratedDomainNameLabelScope property: The value representing the security enum. The 'Unsecure'
     * value is the default value if not selected and means the object's domain name label is not secured against
     * subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name
     * label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label
     * can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label
     * can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be
     * reused within the same resource group, subscription, or tenant.
     * 
     * @return the autoGeneratedDomainNameLabelScope value.
     */
    public DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope() {
        return this.autoGeneratedDomainNameLabelScope;
    }

    /**
     * Set the autoGeneratedDomainNameLabelScope property: The value representing the security enum. The 'Unsecure'
     * value is the default value if not selected and means the object's domain name label is not secured against
     * subdomain takeover. The 'TenantReuse' value is the default value if selected and means the object's domain name
     * label can be reused within the same tenant. The 'SubscriptionReuse' value means the object's domain name label
     * can be reused within the same subscription. The 'ResourceGroupReuse' value means the object's domain name label
     * can be reused within the same resource group. The 'NoReuse' value means the object's domain name label cannot be
     * reused within the same resource group, subscription, or tenant.
     * 
     * @param autoGeneratedDomainNameLabelScope the autoGeneratedDomainNameLabelScope value to set.
     * @return the IpAddress object itself.
     */
    public IpAddress withAutoGeneratedDomainNameLabelScope(DnsNameLabelReusePolicy autoGeneratedDomainNameLabelScope) {
        this.autoGeneratedDomainNameLabelScope = autoGeneratedDomainNameLabelScope;
        return this;
    }

    /**
     * Get the fqdn property: The FQDN for the IP.
     * 
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ports() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property ports in model IpAddress"));
        } else {
            ports().forEach(e -> e.validate());
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model IpAddress"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(IpAddress.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ports", this.ports, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("ip", this.ip);
        jsonWriter.writeStringField("dnsNameLabel", this.dnsNameLabel);
        jsonWriter.writeStringField("autoGeneratedDomainNameLabelScope",
            this.autoGeneratedDomainNameLabelScope == null ? null : this.autoGeneratedDomainNameLabelScope.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IpAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IpAddress if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IpAddress.
     */
    public static IpAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IpAddress deserializedIpAddress = new IpAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ports".equals(fieldName)) {
                    List<Port> ports = reader.readArray(reader1 -> Port.fromJson(reader1));
                    deserializedIpAddress.ports = ports;
                } else if ("type".equals(fieldName)) {
                    deserializedIpAddress.type = ContainerGroupIpAddressType.fromString(reader.getString());
                } else if ("ip".equals(fieldName)) {
                    deserializedIpAddress.ip = reader.getString();
                } else if ("dnsNameLabel".equals(fieldName)) {
                    deserializedIpAddress.dnsNameLabel = reader.getString();
                } else if ("autoGeneratedDomainNameLabelScope".equals(fieldName)) {
                    deserializedIpAddress.autoGeneratedDomainNameLabelScope
                        = DnsNameLabelReusePolicy.fromString(reader.getString());
                } else if ("fqdn".equals(fieldName)) {
                    deserializedIpAddress.fqdn = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIpAddress;
        });
    }
}
