// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The value representing the security enum. The 'Unsecure' value is the default value if not selected and means the
 * object's domain name label is not secured against subdomain takeover. The 'TenantReuse' value is the default value if
 * selected and means the object's domain name label can be reused within the same tenant. The 'SubscriptionReuse' value
 * means the object's domain name label can be reused within the same subscription. The 'ResourceGroupReuse' value means
 * the object's domain name label can be reused within the same resource group. The 'NoReuse' value means the object's
 * domain name label cannot be reused within the same resource group, subscription, or tenant.
 */
public final class DnsNameLabelReusePolicy extends ExpandableStringEnum<DnsNameLabelReusePolicy> {
    /**
     * Static value Unsecure for DnsNameLabelReusePolicy.
     */
    public static final DnsNameLabelReusePolicy UNSECURE = fromString("Unsecure");

    /**
     * Static value TenantReuse for DnsNameLabelReusePolicy.
     */
    public static final DnsNameLabelReusePolicy TENANT_REUSE = fromString("TenantReuse");

    /**
     * Static value SubscriptionReuse for DnsNameLabelReusePolicy.
     */
    public static final DnsNameLabelReusePolicy SUBSCRIPTION_REUSE = fromString("SubscriptionReuse");

    /**
     * Static value ResourceGroupReuse for DnsNameLabelReusePolicy.
     */
    public static final DnsNameLabelReusePolicy RESOURCE_GROUP_REUSE = fromString("ResourceGroupReuse");

    /**
     * Static value Noreuse for DnsNameLabelReusePolicy.
     */
    public static final DnsNameLabelReusePolicy NOREUSE = fromString("Noreuse");

    /**
     * Creates a new instance of DnsNameLabelReusePolicy value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DnsNameLabelReusePolicy() {
    }

    /**
     * Creates or finds a DnsNameLabelReusePolicy from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DnsNameLabelReusePolicy.
     */
    public static DnsNameLabelReusePolicy fromString(String name) {
        return fromString(name, DnsNameLabelReusePolicy.class);
    }

    /**
     * Gets known DnsNameLabelReusePolicy values.
     * 
     * @return known DnsNameLabelReusePolicy values.
     */
    public static Collection<DnsNameLabelReusePolicy> values() {
        return values(DnsNameLabelReusePolicy.class);
    }
}
