// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The properties for confidential container group.
 */
@Fluent
public final class ConfidentialComputeProperties implements JsonSerializable<ConfidentialComputeProperties> {
    /*
     * The base64 encoded confidential compute enforcement policy
     */
    private String ccePolicy;

    /**
     * Creates an instance of ConfidentialComputeProperties class.
     */
    public ConfidentialComputeProperties() {
    }

    /**
     * Get the ccePolicy property: The base64 encoded confidential compute enforcement policy.
     * 
     * @return the ccePolicy value.
     */
    public String ccePolicy() {
        return this.ccePolicy;
    }

    /**
     * Set the ccePolicy property: The base64 encoded confidential compute enforcement policy.
     * 
     * @param ccePolicy the ccePolicy value to set.
     * @return the ConfidentialComputeProperties object itself.
     */
    public ConfidentialComputeProperties withCcePolicy(String ccePolicy) {
        this.ccePolicy = ccePolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ccePolicy", this.ccePolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConfidentialComputeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConfidentialComputeProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ConfidentialComputeProperties.
     */
    public static ConfidentialComputeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ConfidentialComputeProperties deserializedConfidentialComputeProperties
                = new ConfidentialComputeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ccePolicy".equals(fieldName)) {
                    deserializedConfidentialComputeProperties.ccePolicy = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConfidentialComputeProperties;
        });
    }
}
