/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import java.io.IOException;
import java.util.List;

public final class ContainerGroupListResult
implements JsonSerializable<ContainerGroupListResult> {
    private List<ContainerGroupInner> value;
    private String nextLink;

    public List<ContainerGroupInner> value() {
        return this.value;
    }

    public ContainerGroupListResult withValue(List<ContainerGroupInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ContainerGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ContainerGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerGroupListResult)jsonReader.readObject(reader -> {
            ContainerGroupListResult deserializedContainerGroupListResult = new ContainerGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedContainerGroupListResult.value = value = reader.readArray(reader1 -> ContainerGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedContainerGroupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerGroupListResult;
        });
    }
}

