// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.fluent.models.UsageInner;
import java.io.IOException;
import java.util.List;

/**
 * The response containing the usage data.
 */
@Immutable
public final class UsageListResult implements JsonSerializable<UsageListResult> {
    /*
     * The usage data.
     */
    private List<UsageInner> value;

    /**
     * Creates an instance of UsageListResult class.
     */
    public UsageListResult() {
    }

    /**
     * Get the value property: The usage data.
     * 
     * @return the value value.
     */
    public List<UsageInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UsageListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UsageListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UsageListResult.
     */
    public static UsageListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UsageListResult deserializedUsageListResult = new UsageListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<UsageInner> value = reader.readArray(reader1 -> UsageInner.fromJson(reader1));
                    deserializedUsageListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUsageListResult;
        });
    }
}
