/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.GpuResource;
import java.io.IOException;

public final class ResourceLimits
implements JsonSerializable<ResourceLimits> {
    private Double memoryInGB;
    private Double cpu;
    private GpuResource gpu;

    public Double memoryInGB() {
        return this.memoryInGB;
    }

    public ResourceLimits withMemoryInGB(Double memoryInGB) {
        this.memoryInGB = memoryInGB;
        return this;
    }

    public Double cpu() {
        return this.cpu;
    }

    public ResourceLimits withCpu(Double cpu) {
        this.cpu = cpu;
        return this;
    }

    public GpuResource gpu() {
        return this.gpu;
    }

    public ResourceLimits withGpu(GpuResource gpu) {
        this.gpu = gpu;
        return this;
    }

    public void validate() {
        if (this.gpu() != null) {
            this.gpu().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("memoryInGB", (Number)this.memoryInGB);
        jsonWriter.writeNumberField("cpu", (Number)this.cpu);
        jsonWriter.writeJsonField("gpu", (JsonSerializable)this.gpu);
        return jsonWriter.writeEndObject();
    }

    public static ResourceLimits fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceLimits)jsonReader.readObject(reader -> {
            ResourceLimits deserializedResourceLimits = new ResourceLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("memoryInGB".equals(fieldName)) {
                    deserializedResourceLimits.memoryInGB = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("cpu".equals(fieldName)) {
                    deserializedResourceLimits.cpu = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("gpu".equals(fieldName)) {
                    deserializedResourceLimits.gpu = GpuResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceLimits;
        });
    }
}

