// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resource requirements.
 */
@Fluent
public final class ResourceRequirements implements JsonSerializable<ResourceRequirements> {
    /*
     * The resource requests of this container instance.
     */
    private ResourceRequests requests;

    /*
     * The resource limits of this container instance.
     */
    private ResourceLimits limits;

    /**
     * Creates an instance of ResourceRequirements class.
     */
    public ResourceRequirements() {
    }

    /**
     * Get the requests property: The resource requests of this container instance.
     * 
     * @return the requests value.
     */
    public ResourceRequests requests() {
        return this.requests;
    }

    /**
     * Set the requests property: The resource requests of this container instance.
     * 
     * @param requests the requests value to set.
     * @return the ResourceRequirements object itself.
     */
    public ResourceRequirements withRequests(ResourceRequests requests) {
        this.requests = requests;
        return this;
    }

    /**
     * Get the limits property: The resource limits of this container instance.
     * 
     * @return the limits value.
     */
    public ResourceLimits limits() {
        return this.limits;
    }

    /**
     * Set the limits property: The resource limits of this container instance.
     * 
     * @param limits the limits value to set.
     * @return the ResourceRequirements object itself.
     */
    public ResourceRequirements withLimits(ResourceLimits limits) {
        this.limits = limits;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (requests() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property requests in model ResourceRequirements"));
        } else {
            requests().validate();
        }
        if (limits() != null) {
            limits().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ResourceRequirements.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("requests", this.requests);
        jsonWriter.writeJsonField("limits", this.limits);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceRequirements from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceRequirements if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceRequirements.
     */
    public static ResourceRequirements fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceRequirements deserializedResourceRequirements = new ResourceRequirements();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("requests".equals(fieldName)) {
                    deserializedResourceRequirements.requests = ResourceRequests.fromJson(reader);
                } else if ("limits".equals(fieldName)) {
                    deserializedResourceRequirements.limits = ResourceLimits.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceRequirements;
        });
    }
}
