/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DnsConfiguration
implements JsonSerializable<DnsConfiguration> {
    private List<String> nameServers;
    private String searchDomains;
    private String options;
    private static final ClientLogger LOGGER = new ClientLogger(DnsConfiguration.class);

    public List<String> nameServers() {
        return this.nameServers;
    }

    public DnsConfiguration withNameServers(List<String> nameServers) {
        this.nameServers = nameServers;
        return this;
    }

    public String searchDomains() {
        return this.searchDomains;
    }

    public DnsConfiguration withSearchDomains(String searchDomains) {
        this.searchDomains = searchDomains;
        return this;
    }

    public String options() {
        return this.options;
    }

    public DnsConfiguration withOptions(String options) {
        this.options = options;
        return this;
    }

    public void validate() {
        if (this.nameServers() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nameServers in model DnsConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("nameServers", this.nameServers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("searchDomains", this.searchDomains);
        jsonWriter.writeStringField("options", this.options);
        return jsonWriter.writeEndObject();
    }

    public static DnsConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (DnsConfiguration)jsonReader.readObject(reader -> {
            DnsConfiguration deserializedDnsConfiguration = new DnsConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nameServers".equals(fieldName)) {
                    List nameServers;
                    deserializedDnsConfiguration.nameServers = nameServers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("searchDomains".equals(fieldName)) {
                    deserializedDnsConfiguration.searchDomains = reader.getString();
                    continue;
                }
                if ("options".equals(fieldName)) {
                    deserializedDnsConfiguration.options = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDnsConfiguration;
        });
    }
}

