// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.Resource;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.containerinstance.fluent.ContainerGroupsClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in ContainerGroupsClient.
 */
public final class ContainerGroupsClientImpl implements InnerSupportsGet<ContainerGroupInner>,
    InnerSupportsListing<ContainerGroupInner>, InnerSupportsDelete<ContainerGroupInner>, ContainerGroupsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final ContainerGroupsService service;

    /**
     * The service client containing this operation class.
     */
    private final ContainerInstanceManagementClientImpl client;

    /**
     * Initializes an instance of ContainerGroupsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    ContainerGroupsClientImpl(ContainerInstanceManagementClientImpl client) {
        this.service
            = RestProxy.create(ContainerGroupsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerInstanceManagementClientContainerGroups to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerInstanceMan")
    public interface ContainerGroupsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/containerGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupListResult>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupListResult>> listByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupInner>> getByResourceGroup(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName,
            @BodyParam("application/json") ContainerGroupInner containerGroup, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupInner>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName,
            @BodyParam("application/json") Resource resource, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/restart")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> restart(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/stop")
        @ExpectedResponses({ 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> stop(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/start")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> start(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance/containerGroups/{containerGroupName}/outboundNetworkDependenciesEndpoints")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<List<String>>> getOutboundNetworkDependenciesEndpoints(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerGroupListResult>> listByResourceGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<ContainerGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription along with {@link PagedResponse} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), accept,
                context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ContainerGroupInner> listAsync() {
        return new PagedFlux<>(() -> listSinglePageAsync(), nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ContainerGroupInner> listAsync(Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContainerGroupInner> list() {
        return new PagedIterable<>(listAsync());
    }

    /**
     * Get a list of container groups in the specified subscription.
     * 
     * Get a list of container groups in the specified subscription. This operation returns properties of each container
     * group including containers, image registry credentials, restart policy, IP address type, OS type, state, and
     * volumes.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in the specified subscription as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContainerGroupInner> list(Context context) {
        return new PagedIterable<>(listAsync(context));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByResourceGroup(this.client.getEndpoint(),
                this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, accept, context))
            .<PagedResponse<ContainerGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listByResourceGroupSinglePageAsync(String resourceGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ContainerGroupInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ContainerGroupInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux<>(() -> listByResourceGroupSinglePageAsync(resourceGroupName, context),
            nextLink -> listByResourceGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContainerGroupInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName));
    }

    /**
     * Get a list of container groups in the specified subscription and resource group.
     * 
     * Get a list of container groups in a specified subscription and resource group. This operation returns properties
     * of each container group including containers, image registry credentials, restart policy, IP address type, OS
     * type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of container groups in a specified subscription and resource group as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ContainerGroupInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable<>(listByResourceGroupAsync(resourceGroupName, context));
    }

    /**
     * Get the properties of the specified container group.
     * 
     * Gets the properties of the specified container group in the specified subscription and resource group. The
     * operation returns the properties of each container group including containers, image registry credentials,
     * restart policy, IP address type, OS type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified container group in the specified subscription and resource group along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerGroupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the properties of the specified container group.
     * 
     * Gets the properties of the specified container group in the specified subscription and resource group. The
     * operation returns the properties of each container group including containers, image registry credentials,
     * restart policy, IP address type, OS type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified container group in the specified subscription and resource group along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ContainerGroupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String containerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getByResourceGroup(this.client.getEndpoint(), this.client.getSubscriptionId(),
            this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context);
    }

    /**
     * Get the properties of the specified container group.
     * 
     * Gets the properties of the specified container group in the specified subscription and resource group. The
     * operation returns the properties of each container group including containers, image registry credentials,
     * restart policy, IP address type, OS type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified container group in the specified subscription and resource group on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerGroupInner> getByResourceGroupAsync(String resourceGroupName, String containerGroupName) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, containerGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the properties of the specified container group.
     * 
     * Gets the properties of the specified container group in the specified subscription and resource group. The
     * operation returns the properties of each container group including containers, image registry credentials,
     * restart policy, IP address type, OS type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified container group in the specified subscription and resource group along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerGroupInner> getByResourceGroupWithResponse(String resourceGroupName,
        String containerGroupName, Context context) {
        return getByResourceGroupWithResponseAsync(resourceGroupName, containerGroupName, context).block();
    }

    /**
     * Get the properties of the specified container group.
     * 
     * Gets the properties of the specified container group in the specified subscription and resource group. The
     * operation returns the properties of each container group including containers, image registry credentials,
     * restart policy, IP address type, OS type, state, and volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of the specified container group in the specified subscription and resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner getByResourceGroup(String resourceGroupName, String containerGroupName) {
        return getByResourceGroupWithResponse(resourceGroupName, containerGroupName, Context.NONE).getValue();
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String containerGroupName, ContainerGroupInner containerGroup) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroup is required and cannot be null."));
        } else {
            containerGroup.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, containerGroup, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String containerGroupName, ContainerGroupInner containerGroup, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerGroup == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerGroup is required and cannot be null."));
        } else {
            containerGroup.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
            this.client.getApiVersion(), resourceGroupName, containerGroupName, containerGroup, accept, context);
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ContainerGroupInner>, ContainerGroupInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, containerGroupName, containerGroup);
        return this.client.<ContainerGroupInner, ContainerGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            ContainerGroupInner.class, ContainerGroupInner.class, this.client.getContext());
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ContainerGroupInner>, ContainerGroupInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createOrUpdateWithResponseAsync(resourceGroupName, containerGroupName, containerGroup, context);
        return this.client.<ContainerGroupInner, ContainerGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            ContainerGroupInner.class, ContainerGroupInner.class, context);
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerGroupInner>, ContainerGroupInner>
        beginCreateOrUpdate(String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup).getSyncPoller();
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerGroupInner>, ContainerGroupInner> beginCreateOrUpdate(
        String resourceGroupName, String containerGroupName, ContainerGroupInner containerGroup, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup, context)
            .getSyncPoller();
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerGroupInner> createOrUpdateAsync(String resourceGroupName, String containerGroupName,
        ContainerGroupInner containerGroup) {
        return beginCreateOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ContainerGroupInner> createOrUpdateAsync(String resourceGroupName, String containerGroupName,
        ContainerGroupInner containerGroup, Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner createOrUpdate(String resourceGroupName, String containerGroupName,
        ContainerGroupInner containerGroup) {
        return createOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup).block();
    }

    /**
     * Create or update container groups.
     * 
     * Create or update container groups with specified configurations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerGroup The properties of the container group to be created or updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner createOrUpdate(String resourceGroupName, String containerGroupName,
        ContainerGroupInner containerGroup, Context context) {
        return createOrUpdateAsync(resourceGroupName, containerGroupName, containerGroup, context).block();
    }

    /**
     * Update container groups.
     * 
     * Updates container group tags with specified values.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param resource The container group resource with just the tags to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerGroupInner>> updateWithResponseAsync(String resourceGroupName,
        String containerGroupName, Resource resource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error(new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, resource, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update container groups.
     * 
     * Updates container group tags with specified values.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param resource The container group resource with just the tags to be updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ContainerGroupInner>> updateWithResponseAsync(String resourceGroupName,
        String containerGroupName, Resource resource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (resource == null) {
            return Mono.error(new IllegalArgumentException("Parameter resource is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(),
            resourceGroupName, containerGroupName, resource, accept, context);
    }

    /**
     * Update container groups.
     * 
     * Updates container group tags with specified values.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param resource The container group resource with just the tags to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerGroupInner> updateAsync(String resourceGroupName, String containerGroupName,
        Resource resource) {
        return updateWithResponseAsync(resourceGroupName, containerGroupName, resource)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Update container groups.
     * 
     * Updates container group tags with specified values.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param resource The container group resource with just the tags to be updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerGroupInner> updateWithResponse(String resourceGroupName, String containerGroupName,
        Resource resource, Context context) {
        return updateWithResponseAsync(resourceGroupName, containerGroupName, resource, context).block();
    }

    /**
     * Update container groups.
     * 
     * Updates container group tags with specified values.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param resource The container group resource with just the tags to be updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner update(String resourceGroupName, String containerGroupName, Resource resource) {
        return updateWithResponse(resourceGroupName, containerGroupName, resource, Context.NONE).getValue();
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String containerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(),
            resourceGroupName, containerGroupName, accept, context);
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ContainerGroupInner>, ContainerGroupInner> beginDeleteAsync(String resourceGroupName,
        String containerGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, containerGroupName);
        return this.client.<ContainerGroupInner, ContainerGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            ContainerGroupInner.class, ContainerGroupInner.class, this.client.getContext());
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ContainerGroupInner>, ContainerGroupInner> beginDeleteAsync(String resourceGroupName,
        String containerGroupName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, containerGroupName, context);
        return this.client.<ContainerGroupInner, ContainerGroupInner>getLroResult(mono, this.client.getHttpPipeline(),
            ContainerGroupInner.class, ContainerGroupInner.class, context);
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerGroupInner>, ContainerGroupInner> beginDelete(String resourceGroupName,
        String containerGroupName) {
        return this.beginDeleteAsync(resourceGroupName, containerGroupName).getSyncPoller();
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a container group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ContainerGroupInner>, ContainerGroupInner> beginDelete(String resourceGroupName,
        String containerGroupName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, containerGroupName, context).getSyncPoller();
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerGroupInner> deleteAsync(String resourceGroupName, String containerGroupName) {
        return beginDeleteAsync(resourceGroupName, containerGroupName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ContainerGroupInner> deleteAsync(String resourceGroupName, String containerGroupName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, containerGroupName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner delete(String resourceGroupName, String containerGroupName) {
        return deleteAsync(resourceGroupName, containerGroupName).block();
    }

    /**
     * Delete the specified container group.
     * 
     * Delete the specified container group in the specified subscription and resource group. The operation does not
     * delete other resources provided by the user, such as volumes.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerGroupInner delete(String resourceGroupName, String containerGroupName, Context context) {
        return deleteAsync(resourceGroupName, containerGroupName, context).block();
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName,
        String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.restart(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(String resourceGroupName,
        String containerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.restart(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(),
            resourceGroupName, containerGroupName, accept, context);
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String containerGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = restartWithResponseAsync(resourceGroupName, containerGroupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(String resourceGroupName, String containerGroupName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = restartWithResponseAsync(resourceGroupName, containerGroupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String containerGroupName) {
        return this.beginRestartAsync(resourceGroupName, containerGroupName).getSyncPoller();
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(String resourceGroupName, String containerGroupName,
        Context context) {
        return this.beginRestartAsync(resourceGroupName, containerGroupName, context).getSyncPoller();
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String containerGroupName) {
        return beginRestartAsync(resourceGroupName, containerGroupName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> restartAsync(String resourceGroupName, String containerGroupName, Context context) {
        return beginRestartAsync(resourceGroupName, containerGroupName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restart(String resourceGroupName, String containerGroupName) {
        restartAsync(resourceGroupName, containerGroupName).block();
    }

    /**
     * Restarts all containers in a container group.
     * 
     * Restarts all containers in a container group in place. If container image has updates, new image will be
     * downloaded.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restart(String resourceGroupName, String containerGroupName, Context context) {
        restartAsync(resourceGroupName, containerGroupName, context).block();
    }

    /**
     * Stops all containers in a container group.
     * 
     * Stops all containers in a container group. Compute resources will be deallocated and billing will stop.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> stopWithResponseAsync(String resourceGroupName, String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Stops all containers in a container group.
     * 
     * Stops all containers in a container group. Compute resources will be deallocated and billing will stop.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> stopWithResponseAsync(String resourceGroupName, String containerGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.stop(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(),
            resourceGroupName, containerGroupName, accept, context);
    }

    /**
     * Stops all containers in a container group.
     * 
     * Stops all containers in a container group. Compute resources will be deallocated and billing will stop.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> stopAsync(String resourceGroupName, String containerGroupName) {
        return stopWithResponseAsync(resourceGroupName, containerGroupName).flatMap(ignored -> Mono.empty());
    }

    /**
     * Stops all containers in a container group.
     * 
     * Stops all containers in a container group. Compute resources will be deallocated and billing will stop.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String resourceGroupName, String containerGroupName, Context context) {
        return stopWithResponseAsync(resourceGroupName, containerGroupName, context).block();
    }

    /**
     * Stops all containers in a container group.
     * 
     * Stops all containers in a container group. Compute resources will be deallocated and billing will stop.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void stop(String resourceGroupName, String containerGroupName) {
        stopWithResponse(resourceGroupName, containerGroupName, Context.NONE);
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName,
        String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.start(this.client.getEndpoint(), this.client.getSubscriptionId(),
                this.client.getApiVersion(), resourceGroupName, containerGroupName, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String resourceGroupName, String containerGroupName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.start(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(),
            resourceGroupName, containerGroupName, accept, context);
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String containerGroupName) {
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, containerGroupName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginStartAsync(String resourceGroupName, String containerGroupName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, containerGroupName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String containerGroupName) {
        return this.beginStartAsync(resourceGroupName, containerGroupName).getSyncPoller();
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String resourceGroupName, String containerGroupName,
        Context context) {
        return this.beginStartAsync(resourceGroupName, containerGroupName, context).getSyncPoller();
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> startAsync(String resourceGroupName, String containerGroupName) {
        return beginStartAsync(resourceGroupName, containerGroupName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> startAsync(String resourceGroupName, String containerGroupName, Context context) {
        return beginStartAsync(resourceGroupName, containerGroupName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void start(String resourceGroupName, String containerGroupName) {
        startAsync(resourceGroupName, containerGroupName).block();
    }

    /**
     * Starts all containers in a container group.
     * 
     * Starts all containers in a container group. Compute resources will be allocated and billing will start.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void start(String resourceGroupName, String containerGroupName, Context context) {
        startAsync(resourceGroupName, containerGroupName, context).block();
    }

    /**
     * Get all network dependencies for container group.
     * 
     * Gets all the network dependencies for this container group to allow complete control of network setting and
     * configuration. For container groups, this will always be an empty list.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the network dependencies for this container group to allow complete control of network setting and
     * configuration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<List<String>>>
        getOutboundNetworkDependenciesEndpointsWithResponseAsync(String resourceGroupName, String containerGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getOutboundNetworkDependenciesEndpoints(this.client.getEndpoint(),
                this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get all network dependencies for container group.
     * 
     * Gets all the network dependencies for this container group to allow complete control of network setting and
     * configuration. For container groups, this will always be an empty list.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the network dependencies for this container group to allow complete control of network setting and
     * configuration along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<List<String>>> getOutboundNetworkDependenciesEndpointsWithResponseAsync(
        String resourceGroupName, String containerGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getOutboundNetworkDependenciesEndpoints(this.client.getEndpoint(),
            this.client.getSubscriptionId(), this.client.getApiVersion(), resourceGroupName, containerGroupName, accept,
            context);
    }

    /**
     * Get all network dependencies for container group.
     * 
     * Gets all the network dependencies for this container group to allow complete control of network setting and
     * configuration. For container groups, this will always be an empty list.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the network dependencies for this container group to allow complete control of network setting and
     * configuration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<List<String>> getOutboundNetworkDependenciesEndpointsAsync(String resourceGroupName,
        String containerGroupName) {
        return getOutboundNetworkDependenciesEndpointsWithResponseAsync(resourceGroupName, containerGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get all network dependencies for container group.
     * 
     * Gets all the network dependencies for this container group to allow complete control of network setting and
     * configuration. For container groups, this will always be an empty list.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the network dependencies for this container group to allow complete control of network setting and
     * configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<List<String>> getOutboundNetworkDependenciesEndpointsWithResponse(String resourceGroupName,
        String containerGroupName, Context context) {
        return getOutboundNetworkDependenciesEndpointsWithResponseAsync(resourceGroupName, containerGroupName, context)
            .block();
    }

    /**
     * Get all network dependencies for container group.
     * 
     * Gets all the network dependencies for this container group to allow complete control of network setting and
     * configuration. For container groups, this will always be an empty list.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the network dependencies for this container group to allow complete control of network setting and
     * configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public List<String> getOutboundNetworkDependenciesEndpoints(String resourceGroupName, String containerGroupName) {
        return getOutboundNetworkDependenciesEndpointsWithResponse(resourceGroupName, containerGroupName, Context.NONE)
            .getValue();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the container group list response that contains the container group properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ContainerGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the container group list response that contains the container group properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the container group list response that contains the container group properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ContainerGroupInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the container group list response that contains the container group properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ContainerGroupInner>> listByResourceGroupNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
