// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.UsageName;
import java.io.IOException;

/**
 * A single usage result.
 */
@Immutable
public final class UsageInner implements JsonSerializable<UsageInner> {
    /*
     * Id of the usage result
     */
    private String id;

    /*
     * Unit of the usage result
     */
    private String unit;

    /*
     * The current usage of the resource
     */
    private Integer currentValue;

    /*
     * The maximum permitted usage of the resource.
     */
    private Integer limit;

    /*
     * The name object of the resource
     */
    private UsageName name;

    /**
     * Creates an instance of UsageInner class.
     */
    public UsageInner() {
    }

    /**
     * Get the id property: Id of the usage result.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the unit property: Unit of the usage result.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the currentValue property: The current usage of the resource.
     * 
     * @return the currentValue value.
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: The maximum permitted usage of the resource.
     * 
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Get the name property: The name object of the resource.
     * 
     * @return the name value.
     */
    public UsageName name() {
        return this.name;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UsageInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UsageInner if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the UsageInner.
     */
    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUsageInner.id = reader.getString();
                } else if ("unit".equals(fieldName)) {
                    deserializedUsageInner.unit = reader.getString();
                } else if ("currentValue".equals(fieldName)) {
                    deserializedUsageInner.currentValue = reader.getNullable(JsonReader::getInt);
                } else if ("limit".equals(fieldName)) {
                    deserializedUsageInner.limit = reader.getNullable(JsonReader::getInt);
                } else if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = UsageName.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUsageInner;
        });
    }
}
