// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Image registry credential. */
@Fluent
public final class ImageRegistryCredential {
    /*
     * The Docker image registry server without a protocol such as "http" and "https".
     */
    @JsonProperty(value = "server", required = true)
    private String server;

    /*
     * The username for the private registry.
     */
    @JsonProperty(value = "username")
    private String username;

    /*
     * The password for the private registry.
     */
    @JsonProperty(value = "password")
    private String password;

    /*
     * The identity for the private registry.
     */
    @JsonProperty(value = "identity")
    private String identity;

    /*
     * The identity URL for the private registry.
     */
    @JsonProperty(value = "identityUrl")
    private String identityUrl;

    /** Creates an instance of ImageRegistryCredential class. */
    public ImageRegistryCredential() {
    }

    /**
     * Get the server property: The Docker image registry server without a protocol such as "http" and "https".
     *
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The Docker image registry server without a protocol such as "http" and "https".
     *
     * @param server the server value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the username property: The username for the private registry.
     *
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username for the private registry.
     *
     * @param username the username value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password for the private registry.
     *
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password for the private registry.
     *
     * @param password the password value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the identity property: The identity for the private registry.
     *
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity for the private registry.
     *
     * @param identity the identity value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the identityUrl property: The identity URL for the private registry.
     *
     * @return the identityUrl value.
     */
    public String identityUrl() {
        return this.identityUrl;
    }

    /**
     * Set the identityUrl property: The identity URL for the private registry.
     *
     * @param identityUrl the identityUrl value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withIdentityUrl(String identityUrl) {
        this.identityUrl = identityUrl;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (server() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property server in model ImageRegistryCredential"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImageRegistryCredential.class);
}
