// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.containerinstance.models.UsageName;
import com.fasterxml.jackson.annotation.JsonProperty;

/** A single usage result. */
@Immutable
public final class UsageInner {
    /*
     * Id of the usage result
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Unit of the usage result
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private String unit;

    /*
     * The current usage of the resource
     */
    @JsonProperty(value = "currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Integer currentValue;

    /*
     * The maximum permitted usage of the resource.
     */
    @JsonProperty(value = "limit", access = JsonProperty.Access.WRITE_ONLY)
    private Integer limit;

    /*
     * The name object of the resource
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private UsageName name;

    /** Creates an instance of UsageInner class. */
    public UsageInner() {
    }

    /**
     * Get the id property: Id of the usage result.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the unit property: Unit of the usage result.
     *
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Get the currentValue property: The current usage of the resource.
     *
     * @return the currentValue value.
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the limit property: The maximum permitted usage of the resource.
     *
     * @return the limit value.
     */
    public Integer limit() {
        return this.limit;
    }

    /**
     * Get the name property: The name object of the resource.
     *
     * @return the name value.
     */
    public UsageName name() {
        return this.name;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }
}
