// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The container group list response that contains the container group properties. */
@Fluent
public final class ContainerGroupListResult {
    /*
     * The list of container groups.
     */
    @JsonProperty(value = "value")
    private List<ContainerGroupInner> value;

    /*
     * The URI to fetch the next page of container groups.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of ContainerGroupListResult class. */
    public ContainerGroupListResult() {
    }

    /**
     * Get the value property: The list of container groups.
     *
     * @return the value value.
     */
    public List<ContainerGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of container groups.
     *
     * @param value the value value to set.
     * @return the ContainerGroupListResult object itself.
     */
    public ContainerGroupListResult withValue(List<ContainerGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of container groups.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of container groups.
     *
     * @param nextLink the nextLink value to set.
     * @return the ContainerGroupListResult object itself.
     */
    public ContainerGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
