// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The response containing list of capabilities. */
@Fluent
public final class CapabilitiesListResult {
    /*
     * The list of capabilities.
     */
    @JsonProperty(value = "value")
    private List<Capabilities> value;

    /*
     * The URI to fetch the next page of capabilities.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of CapabilitiesListResult class. */
    public CapabilitiesListResult() {
    }

    /**
     * Get the value property: The list of capabilities.
     *
     * @return the value value.
     */
    public List<Capabilities> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of capabilities.
     *
     * @param value the value value to set.
     * @return the CapabilitiesListResult object itself.
     */
    public CapabilitiesListResult withValue(List<Capabilities> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of capabilities.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of capabilities.
     *
     * @param nextLink the nextLink value to set.
     * @return the CapabilitiesListResult object itself.
     */
    public CapabilitiesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
