/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.azure.resourcemanager.containerinstance.models.ContainerProbe;
import com.azure.resourcemanager.containerinstance.models.ContainerPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerProperties {
    @JsonProperty(value="image", required=true)
    private String image;
    @JsonProperty(value="command")
    private List<String> command;
    @JsonProperty(value="ports")
    private List<ContainerPort> ports;
    @JsonProperty(value="environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerPropertiesInstanceView instanceView;
    @JsonProperty(value="resources", required=true)
    private ResourceRequirements resources;
    @JsonProperty(value="volumeMounts")
    private List<VolumeMount> volumeMounts;
    @JsonProperty(value="livenessProbe")
    private ContainerProbe livenessProbe;
    @JsonProperty(value="readinessProbe")
    private ContainerProbe readinessProbe;
    @JsonProperty(value="securityContext")
    private SecurityContextDefinition securityContext;
    private static final ClientLogger LOGGER = new ClientLogger(ContainerProperties.class);

    public String image() {
        return this.image;
    }

    public ContainerProperties withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public ContainerProperties withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<ContainerPort> ports() {
        return this.ports;
    }

    public ContainerProperties withPorts(List<ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public ContainerProperties withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public ContainerPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ResourceRequirements resources() {
        return this.resources;
    }

    public ContainerProperties withResources(ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public ContainerProperties withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public ContainerProbe livenessProbe() {
        return this.livenessProbe;
    }

    public ContainerProperties withLivenessProbe(ContainerProbe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    public ContainerProbe readinessProbe() {
        return this.readinessProbe;
    }

    public ContainerProperties withReadinessProbe(ContainerProbe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    public SecurityContextDefinition securityContext() {
        return this.securityContext;
    }

    public ContainerProperties withSecurityContext(SecurityContextDefinition securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public void validate() {
        if (this.image() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property image in model ContainerProperties"));
        }
        if (this.ports() != null) {
            this.ports().forEach(e -> e.validate());
        }
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.resources() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property resources in model ContainerProperties"));
        }
        this.resources().validate();
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.livenessProbe() != null) {
            this.livenessProbe().validate();
        }
        if (this.readinessProbe() != null) {
            this.readinessProbe().validate();
        }
        if (this.securityContext() != null) {
            this.securityContext().validate();
        }
    }
}

