/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupInner;
import com.azure.resourcemanager.containerinstance.implementation.ContainerGroupImpl;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroup;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIpAddressType;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupNetworkProtocol;
import com.azure.resourcemanager.containerinstance.models.ContainerNetworkProtocol;
import com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.GpuResource;
import com.azure.resourcemanager.containerinstance.models.GpuSku;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.Port;
import com.azure.resourcemanager.containerinstance.models.ResourceRequests;
import com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import java.util.ArrayList;
import java.util.Map;

class ContainerImpl
implements ContainerGroup.DefinitionStages.ContainerInstanceDefinitionStages.ContainerInstanceDefinition<ContainerGroup.DefinitionStages.WithNextContainerInstance> {
    private Container innerContainer;
    private ContainerGroupImpl parent;

    ContainerImpl(ContainerGroupImpl parent, String containerName) {
        this.parent = parent;
        this.innerContainer = new Container().withName(containerName).withResources(new ResourceRequirements().withRequests(new ResourceRequests().withCpu(1.0).withMemoryInGB(1.5)));
    }

    public ContainerGroupImpl attach() {
        if (((ContainerGroupInner)((Object)this.parent.innerModel())).containers() == null) {
            ((ContainerGroupInner)((Object)this.parent.innerModel())).withContainers(new ArrayList<Container>());
        }
        ((ContainerGroupInner)((Object)this.parent.innerModel())).containers().add(this.innerContainer);
        return this.parent;
    }

    public ContainerImpl withImage(String imageName) {
        this.innerContainer.withImage(imageName);
        return this;
    }

    public ContainerImpl withoutPorts() {
        this.innerContainer.withPorts(null);
        return this;
    }

    public ContainerImpl withExternalTcpPorts(int ... ports) {
        for (int port : ports) {
            this.withExternalTcpPort(port);
        }
        return this;
    }

    public ContainerImpl withExternalTcpPort(int port) {
        this.ensureParentIpAddress().ports().add(new Port().withPort(port).withProtocol(ContainerGroupNetworkProtocol.TCP));
        this.withInternalTcpPort(port);
        return this;
    }

    private IpAddress ensureParentIpAddress() {
        if (((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress() == null) {
            ((ContainerGroupInner)((Object)this.parent.innerModel())).withIpAddress(new IpAddress());
        }
        if (((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().type() == null && ((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().dnsNameLabel() == null) {
            ((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().withType(ContainerGroupIpAddressType.PRIVATE);
        } else {
            ((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().withType(ContainerGroupIpAddressType.PUBLIC);
        }
        if (((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().ports() == null) {
            ((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress().withPorts(new ArrayList<Port>());
        }
        return ((ContainerGroupInner)((Object)this.parent.innerModel())).ipAddress();
    }

    public ContainerImpl withExternalUdpPorts(int ... ports) {
        for (int port : ports) {
            this.withExternalUdpPort(port);
        }
        return this;
    }

    public ContainerImpl withExternalUdpPort(int port) {
        this.ensureParentIpAddress().ports().add(new Port().withPort(port).withProtocol(ContainerGroupNetworkProtocol.UDP));
        this.withInternalUdpPort(port);
        return this;
    }

    public ContainerImpl withInternalTcpPorts(int ... ports) {
        for (int port : ports) {
            this.withInternalTcpPort(port);
        }
        return this;
    }

    public ContainerImpl withInternalUdpPorts(int ... ports) {
        for (int port : ports) {
            this.withInternalUdpPort(port);
        }
        return this;
    }

    public ContainerImpl withInternalTcpPort(int port) {
        if (this.innerContainer.ports() == null) {
            this.innerContainer.withPorts(new ArrayList<ContainerPort>());
        }
        this.innerContainer.ports().add(new ContainerPort().withPort(port).withProtocol(ContainerNetworkProtocol.TCP));
        return this;
    }

    public ContainerImpl withInternalUdpPort(int port) {
        if (this.innerContainer.ports() == null) {
            this.innerContainer.withPorts(new ArrayList<ContainerPort>());
        }
        this.innerContainer.ports().add(new ContainerPort().withPort(port).withProtocol(ContainerNetworkProtocol.UDP));
        return this;
    }

    public ContainerImpl withCpuCoreCount(double cpuCoreCount) {
        this.innerContainer.resources().requests().withCpu(cpuCoreCount);
        return this;
    }

    public ContainerImpl withGpuResource(int gpuCoreCount, GpuSku gpuSku) {
        this.innerContainer.resources().requests().withGpu(new GpuResource().withCount(gpuCoreCount).withSku(gpuSku));
        return this;
    }

    public ContainerImpl withMemorySizeInGB(double memorySize) {
        this.innerContainer.resources().requests().withMemoryInGB(memorySize);
        return this;
    }

    public ContainerImpl withStartingCommandLine(String executable, String ... parameters) {
        this.withStartingCommandLine(executable);
        if (parameters != null) {
            for (String parameter : parameters) {
                this.withStartingCommandLine(parameter);
            }
        }
        return this;
    }

    public ContainerImpl withStartingCommandLine(String commandLine) {
        if (this.innerContainer.command() == null) {
            this.innerContainer.withCommand(new ArrayList<String>());
        }
        this.innerContainer.command().add(commandLine);
        return this;
    }

    public ContainerImpl withEnvironmentVariables(Map<String, String> environmentVariables) {
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            this.withEnvironmentVariable(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ContainerImpl withEnvironmentVariable(String envName, String envValue) {
        if (this.innerContainer.environmentVariables() == null) {
            this.innerContainer.withEnvironmentVariables(new ArrayList<EnvironmentVariable>());
        }
        this.innerContainer.environmentVariables().add(new EnvironmentVariable().withName(envName).withValue(envValue));
        return this;
    }

    public ContainerImpl withEnvironmentVariableWithSecuredValue(Map<String, String> environmentVariables) {
        for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
            this.withEnvironmentVariableWithSecuredValue(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ContainerImpl withEnvironmentVariableWithSecuredValue(String envName, String securedValue) {
        if (this.innerContainer.environmentVariables() == null) {
            this.innerContainer.withEnvironmentVariables(new ArrayList<EnvironmentVariable>());
        }
        this.innerContainer.environmentVariables().add(new EnvironmentVariable().withName(envName).withSecureValue(securedValue));
        return this;
    }

    public ContainerImpl withVolumeMountSetting(String volumeName, String mountPath) {
        if (this.innerContainer.volumeMounts() == null) {
            this.innerContainer.withVolumeMounts(new ArrayList<VolumeMount>());
        }
        this.innerContainer.volumeMounts().add(new VolumeMount().withName(volumeName).withMountPath(mountPath).withReadOnly(false));
        return this;
    }

    public ContainerImpl withVolumeMountSetting(Map<String, String> volumeMountSetting) {
        for (Map.Entry<String, String> entry : volumeMountSetting.entrySet()) {
            this.withVolumeMountSetting(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ContainerImpl withReadOnlyVolumeMountSetting(String volumeName, String mountPath) {
        if (this.innerContainer.volumeMounts() == null) {
            this.innerContainer.withVolumeMounts(new ArrayList<VolumeMount>());
        }
        this.innerContainer.volumeMounts().add(new VolumeMount().withName(volumeName).withMountPath(mountPath).withReadOnly(true));
        return this;
    }

    public ContainerImpl withReadOnlyVolumeMountSetting(Map<String, String> volumeMountSetting) {
        for (Map.Entry<String, String> entry : volumeMountSetting.entrySet()) {
            this.withReadOnlyVolumeMountSetting(entry.getKey(), entry.getValue());
        }
        return this;
    }
}

