// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Container group subnet information. */
@Fluent
public final class ContainerGroupSubnetId {
    /*
     * Resource ID of virtual network and subnet.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * Friendly name for the subnet.
     */
    @JsonProperty(value = "name")
    private String name;

    /**
     * Get the id property: Resource ID of virtual network and subnet.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID of virtual network and subnet.
     *
     * @param id the id value to set.
     * @return the ContainerGroupSubnetId object itself.
     */
    public ContainerGroupSubnetId withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Friendly name for the subnet.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Friendly name for the subnet.
     *
     * @param name the name value to set.
     * @return the ContainerGroupSubnetId object itself.
     */
    public ContainerGroupSubnetId withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property id in model ContainerGroupSubnetId"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupSubnetId.class);
}
