/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.VMGuestPatchClassificationWindows;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class WindowsParameters
implements JsonSerializable<WindowsParameters> {
    private List<VMGuestPatchClassificationWindows> classificationsToInclude;
    private List<String> kbNumbersToInclude;
    private List<String> kbNumbersToExclude;
    private Boolean excludeKbsRequiringReboot;
    private OffsetDateTime maxPatchPublishDate;
    private List<String> patchNameMasksToInclude;
    private List<String> patchNameMasksToExclude;

    public List<VMGuestPatchClassificationWindows> classificationsToInclude() {
        return this.classificationsToInclude;
    }

    public WindowsParameters withClassificationsToInclude(List<VMGuestPatchClassificationWindows> classificationsToInclude) {
        this.classificationsToInclude = classificationsToInclude;
        return this;
    }

    public List<String> kbNumbersToInclude() {
        return this.kbNumbersToInclude;
    }

    public WindowsParameters withKbNumbersToInclude(List<String> kbNumbersToInclude) {
        this.kbNumbersToInclude = kbNumbersToInclude;
        return this;
    }

    public List<String> kbNumbersToExclude() {
        return this.kbNumbersToExclude;
    }

    public WindowsParameters withKbNumbersToExclude(List<String> kbNumbersToExclude) {
        this.kbNumbersToExclude = kbNumbersToExclude;
        return this;
    }

    public Boolean excludeKbsRequiringReboot() {
        return this.excludeKbsRequiringReboot;
    }

    public WindowsParameters withExcludeKbsRequiringReboot(Boolean excludeKbsRequiringReboot) {
        this.excludeKbsRequiringReboot = excludeKbsRequiringReboot;
        return this;
    }

    public OffsetDateTime maxPatchPublishDate() {
        return this.maxPatchPublishDate;
    }

    public WindowsParameters withMaxPatchPublishDate(OffsetDateTime maxPatchPublishDate) {
        this.maxPatchPublishDate = maxPatchPublishDate;
        return this;
    }

    public List<String> patchNameMasksToInclude() {
        return this.patchNameMasksToInclude;
    }

    public WindowsParameters withPatchNameMasksToInclude(List<String> patchNameMasksToInclude) {
        this.patchNameMasksToInclude = patchNameMasksToInclude;
        return this;
    }

    public List<String> patchNameMasksToExclude() {
        return this.patchNameMasksToExclude;
    }

    public WindowsParameters withPatchNameMasksToExclude(List<String> patchNameMasksToExclude) {
        this.patchNameMasksToExclude = patchNameMasksToExclude;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("classificationsToInclude", this.classificationsToInclude, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("kbNumbersToInclude", this.kbNumbersToInclude, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("kbNumbersToExclude", this.kbNumbersToExclude, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("excludeKbsRequiringReboot", this.excludeKbsRequiringReboot);
        jsonWriter.writeStringField("maxPatchPublishDate", this.maxPatchPublishDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.maxPatchPublishDate));
        jsonWriter.writeArrayField("patchNameMasksToInclude", this.patchNameMasksToInclude, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("patchNameMasksToExclude", this.patchNameMasksToExclude, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static WindowsParameters fromJson(JsonReader jsonReader) throws IOException {
        return (WindowsParameters)jsonReader.readObject(reader -> {
            WindowsParameters deserializedWindowsParameters = new WindowsParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classificationsToInclude".equals(fieldName)) {
                    List classificationsToInclude;
                    deserializedWindowsParameters.classificationsToInclude = classificationsToInclude = reader.readArray(reader1 -> VMGuestPatchClassificationWindows.fromString(reader1.getString()));
                    continue;
                }
                if ("kbNumbersToInclude".equals(fieldName)) {
                    List kbNumbersToInclude;
                    deserializedWindowsParameters.kbNumbersToInclude = kbNumbersToInclude = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("kbNumbersToExclude".equals(fieldName)) {
                    List kbNumbersToExclude;
                    deserializedWindowsParameters.kbNumbersToExclude = kbNumbersToExclude = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("excludeKbsRequiringReboot".equals(fieldName)) {
                    deserializedWindowsParameters.excludeKbsRequiringReboot = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("maxPatchPublishDate".equals(fieldName)) {
                    deserializedWindowsParameters.maxPatchPublishDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("patchNameMasksToInclude".equals(fieldName)) {
                    List patchNameMasksToInclude;
                    deserializedWindowsParameters.patchNameMasksToInclude = patchNameMasksToInclude = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("patchNameMasksToExclude".equals(fieldName)) {
                    List patchNameMasksToExclude;
                    deserializedWindowsParameters.patchNameMasksToExclude = patchNameMasksToExclude = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWindowsParameters;
        });
    }
}

